
// df0 x2 interpolation filter
#define FIR_TAPS 167
static const int df0_coeffs[FIR_TAPS] = {
    -12, 0, 26, 0, -52, 0, 95, 0, -163, 0, 265, 0, -414, 0, 626, 0,
    -918, 0, 1316, 0, -1846, 0, 2542, 0, -3440, 0, 4587, 0, -6031, 0,
    7831, 0, -10051, 0, 12765, 0, -16052, 0, 20003, 0, -24719, 0, 30312, 0,
    -36908, 0, 44651, 0, -53702, 0, 64253, 0, -76529, 0, 90803, 0,
    -107417, 0, 126805, 0, -149544, 0, 176416, 0, -208527, 0, 247500, 0,
    -295824, 0, 357532, 0, -439605, 0, 555269, 0, -732914, 0, 1046453, 0,
    -1767069, 0, 5335991, 8388608, 5335991, 0, -1767069, 0, 1046453, 0,
    -732914, 0, 555269, 0, -439605, 0, 357532, 0, -295824, 0, 247500, 0,
    -208527, 0, 176416, 0, -149544, 0, 126805, 0, -107417, 0, 90803, 0,
    -76529, 0, 64253, 0, -53702, 0, 44651, 0, -36908, 0, 30312, 0,
    -24719, 0, 20003, 0, -16052, 0, 12765, 0, -10051, 0, 7831, 0,
    -6031, 0, 4587, 0, -3440, 0, 2542, 0, -1846, 0, 1316, 0, -918, 0,
    626, 0, -414, 0, 265, 0, -163, 0, 95, 0, -52, 0, 26, 0, -12
};

static const int df0_coeffs_packed[FIR_TAPS] = {
    -12, 26, -52, 95, -163, 265, -414, 626, -918, 1316, -1846, 2542,
    -3440, 4587, -6031, 7831, -10051, 12765, -16052, 20003, -24719, 30312,
    -36908, 44651, -53702, 64253, -76529, 90803, -107417, 126805, -149544,
    176416, -208527, 247500, -295824, 357532, -439605, 555269, -732914,
    1046453, -1767069, 5335991, 8388608, 5335991, -1767069, 1046453,
    -732914, 555269, -439605, 357532, -295824, 247500, -208527, 176416,
    -149544, 126805, -107417, 90803, -76529, 64253, -53702, 44651,
    -36908, 30312, -24719, 20003, -16052, 12765, -10051, 7831, -6031,
    4587, -3440, 2542, -1846, 1316, -918, 626, -414, 265, -163, 95,
    -52, 26, -12
};

typedef struct _fir_filter_ctx
{
    int32_t* coeffs;
    int32_t* delays_l;
    int32_t* delays_r;
    int32_t  delays_ptr;
}fir_filter_ctx;

static fir_filter_ctx fir_ctx;
static int32_t fir_delays_l[FIR_TAPS] = {0};
static int32_t fir_delays_r[FIR_TAPS] = {0};

// 1 stereo samples in (2xint32_t, l/r), 2 stereo samples out (4xint32_t, l0/r0/l1/r1)
extern int32_t  fir_interp_2x_symm_2ch(int32_t* in, int32_t* out, fir_filter_ctx* ctx);

// 2 stereo samples in (4xint32_t, l0/r0/l1/r1), 4 stereo samples out (8xint32_t, l0/r0/l1/r1/...)
extern int32_t  fir_interp_2x_symm_2ch_2smpl(int32_t* in, int32_t* out, fir_filter_ctx* ctx);

void dsp_init()
{
    fir_ctx.coeffs = df0_coeffs_packed;//df0_coeffs;
    fir_ctx.delays_l = fir_delays_l;
    fir_ctx.delays_r = fir_delays_r;
    fir_ctx.delays_ptr = 0;
}