/*
    *MIPS32 inpstructions assembler code
*/
    
/*
     Control data structure     
static struct {
    int acc1[2];
    int acc2[2];
    int acc3[2];
    int acc4[2];
    int acc5[2];
    int rMDO[2];
} tSdmCtrl;
     
*/
    
/* Global functions declarations */
.global sony5sdm_x8
.global sony5sdm_x4
    
/*
    sony5sdm_x8 - SONY 5-th order SD modulator with x8 oversampling ratio.
		One pass generate 8 data bits and shift into shreg[] register.
		Function read four dual channel int32 samples and do four passes
		with write 32 bit dual channel resut to output.
     
    external declaration:     extern void sony5sdm_x8(void *pSrc, void *pDst, void *pSdm);

    input:
    pSrc - int32 source data pointer ($a0)
    pDSDM - sdm delay acc array pointer ($a2)

    output:
    pDest - uint32_t destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read four dual channel sample, upsample and return eight dual channel samples.
*/
sony5sdm_x8:
    // ******************* Left channel processing **********************
    // pass counter initialisation
    LI $t0, 4
    // Load smd accumulators
    LW $t1, 0($a2)  // acc1
    LW $t2, 8($a2)  // acc2
    LW $t3, 16($a2) // acc3
    LW $t4, 24($a2) // acc4
    LW $t5, 32($a2) // acc5
    LW $t6, 40($a2) // reg MDO
    // load source address
    ADDU $t9, $a0, 0
    
    .sdm8passL:
    // load input data
    LW $t8, ($t9)
    // Gain correct (-6db)
    SHRA_R.W $t8, $t8, 1

    // ----------- SDM bit 1 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 2 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 3 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 4 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 5 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 6 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 7 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 8 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // address input data increment
    ADDU $t9, $t9, 8
    // pass counter decrement
    ADDU $t0, $t0, -1
    // check repeat counter
    BNE $t0, $zero, .sdm8passL
    
    // save result
    SW $t7, 0($a1)
    // Save sdm data
    SW $t1, 0($a2)  // acc1
    SW $t2, 8($a2)  // acc2
    SW $t3, 16($a2) // acc3
    SW $t4, 24($a2) // acc4
    SW $t5, 32($a2) // acc5
    SW $t6, 40($a2) // reg MDO
    
    
    
    // ******************* Right channel processing **********************
    // pass counter initialisation
    LI $t0, 4
    // Load smd accumulators
    LW $t1, 4($a2)  // acc1
    LW $t2, 12($a2) // acc2
    LW $t3, 20($a2) // acc3
    LW $t4, 28($a2) // acc4
    LW $t5, 36($a2) // acc5
    LW $t6, 44($a2) // reg MDO
    // load source address
    ADDU $t9, $a0, 4
        
    .sdm8passR:
    // load input data
    LW $t8, ($t9)
    // Gain correct (-6db)
    SHRA_R.W $t8, $t8, 1

    // ----------- SDM bit 1 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 2 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 3 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 4 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 5 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 6 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 7 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 8 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // address input data increment
    ADDU $t9, $t9, 8
    // pass counter decrement
    ADDU $t0, $t0, -1
    // check repeat counter
    BNE $t0, $zero, .sdm8passR
        
    // save result
    SW $t7, 4($a1)
    // Save sdm data
    SW $t1, 4($a2)  // acc1
    SW $t2, 12($a2) // acc2
    SW $t3, 20($a2) // acc3
    SW $t4, 28($a2) // acc4
    SW $t5, 36($a2) // acc5
    SW $t6, 44($a2) // reg MDO
    
    // restore address pointer
    J $ra

    
   

    
    
    
    
    
    
    
    
    
    
    
/*
    sony5sdm_x4 - SONY 5-th order SD modulator with x4 oversampling ratio.
		One pass generate 4 data bits and shift into shreg[] register.
		Function read four dual channel int32 samples and do 8 passes
		with write 32 bit dual channel resut to output.
     
    external declaration:     extern void sony5sdm_x4(void *pSrc, void *pDst, void *pSdm);

    input:
    pSrc - int32 source data pointer ($a0)
    pDSDM - sdm delay acc array pointer ($a2)

    output:
    pDest - uint32_t destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read four dual channel sample, upsample and return eight dual channel samples.
*/
sony5sdm_x4:
    // ******************* Left channel processing **********************
    // pass counter initialisation
    LI $t0, 8
    // Load smd accumulators
    LW $t1, 0($a2)  // acc1
    LW $t2, 8($a2)  // acc2
    LW $t3, 16($a2) // acc3
    LW $t4, 24($a2) // acc4
    LW $t5, 32($a2) // acc5
    LW $t6, 40($a2) // reg MDO
    // load source address
    ADDU $t9, $a0, 0
    
    .sdm16passL:
    // load input data
    LW $t8, ($t9)
    // Gain correct (-6db)
    SHRA_R.W $t8, $t8, 1

    // ----------- SDM bit 1 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 2 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 3 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 4 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // address input data increment
    ADDU $t9, $t9, 8
    // pass counter decrement
    ADDU $t0, $t0, -1
    // check repeat counter
    BNE $t0, $zero, .sdm16passL
    
    // save result
    SW $t7, 0($a1)
    // Save sdm data
    SW $t1, 0($a2)  // acc1
    SW $t2, 8($a2)  // acc2
    SW $t3, 16($a2) // acc3
    SW $t4, 24($a2) // acc4
    SW $t5, 32($a2) // acc5
    SW $t6, 40($a2) // reg MDO
    
    
    
    // ******************* Right channel processing **********************
    // pass counter initialisation
    LI $t0, 8
    // Load smd accumulators
    LW $t1, 4($a2)  // acc1
    LW $t2, 12($a2) // acc2
    LW $t3, 20($a2) // acc3
    LW $t4, 28($a2) // acc4
    LW $t5, 36($a2) // acc5
    LW $t6, 44($a2) // reg MDO
    // load source address
    ADDU $t9, $a0, 4
        
    .sdm16passR:
    // load input data
    LW $t8, ($t9)
    // Gain correct (-6db)
    SHRA_R.W $t8, $t8, 1

    // ----------- SDM bit 1 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 2 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 3 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // ----------- SDM bit 4 ---------------------------
    // acc1 proc
    SUBU $v0, $t8, $t6
    ADDU $t1, $t1, $v0
    // acc2 proc
    SHRA_R.W $v0, $t1, 1
    ADDU $t2, $t2, $v0
    SHRA_R.W $v0, $t3, 9
    SUBU $t2, $t2, $v0
    // acc3 proc
    SHRA_R.W $v0, $t2, 2
    ADDU $t3, $t3, $v0
    // acc4 proc
    SHRA_R.W $v0, $t3, 3
    ADDU $t4, $t4, $v0
    SHRA_R.W $v0, $t5, 5
    SUBU $t4, $t4, $v0
    // acc5 proc
    SHRA_R.W $v0, $t4, 4
    ADDU $t5, $t5, $v0
    // Update MDO proc
    ADDU $t6, $t1, $t2
    ADDU $t6, $t6, $t3
    ADDU $t6, $t6, $t4
    ADDU $t6, $t6, $t5
    // quantize output
    SHLL_S.W $t6, $t6, 31
    SRA $t6, $t6, 2
    // get output bit
    SRL $v0, $t6, 31
    // shift and load new bit in output bitsream register
    SLL $t7, $t7, 1
    OR $t7, $t7, $v0
    
    // address input data increment
    ADDU $t9, $t9, 8
    // pass counter decrement
    ADDU $t0, $t0, -1
    // check repeat counter
    BNE $t0, $zero, .sdm16passR
        
    // save result
    SW $t7, 4($a1)
    // Save sdm data
    SW $t1, 4($a2)  // acc1
    SW $t2, 12($a2) // acc2
    SW $t3, 20($a2) // acc3
    SW $t4, 28($a2) // acc4
    SW $t5, 36($a2) // acc5
    SW $t6, 44($a2) // reg MDO
    
    // restore address pointer
    J $ra