

.global fir2
.global fir3
.global fir4
     

    
/*
    fir2 - FIR x2 upsampler
    Read from source two dual channel audio data samples,
    upsemple rate, and write to destination four dual channel samples
     
    external declaration:     extern void fir2(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0) with data format 32bit left - 32bit right

    output:
    pDst - int32 result destination data pointer ($a1) with data format 32bit left - 32bit right

    Source data array must contain dual channel int32 data samples.
    Function read 2 dual channel samples, upsample and return 4 dual channel samples.
*/
fir2:  
    // save data to stack
    ADDU $sp, $sp, -16
    SW $s0, 0($sp)
    SW $s1, 4($sp)
    SW $s2, 8($sp)
    SW $s3, 12($sp)
    
    // load 6 coefficients
    LI $s0, -4224
    LI $s1, 34496
    LI $s2, -151712
    LI $s3, 483808
    LI $a2, -1347584
    LI $a3, 5179520

    // ********************** Left channel pass 1 ******************************
    // load 12 data samples 1
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 32($a0)
    LW $t5, 40($a0)
    LW $t6, 48($a0)
    LW $t7, 56($a0)
    LW $t8, 64($a0)
    LW $t9, 72($a0)
    LW $v0, 80($a0)
    LW $v1, 88($a0)
    // multiply-acccumulate
    MULT $t0, $s0
    MADD $t1, $s1
    MADD $t2, $s2
    MADD $t3, $s3
    MADD $t4, $a2
    MADD $t5, $a3
    MADD $t6, $a3
    MADD $t7, $a2
    MADD $t8, $s3
    MADD $t9, $s2
    MADD $v0, $s1
    MADD $v1, $s0
    
    // Left channel sample copy
    LW $t0, 48($a0)
    SW $t0, 8($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t0, $ac0, 23
    // save result to $a1 pointer
    SW $t0, 0($a1)
    
    // ********************** Left channel pass 2 ******************************
    // load next sample
    LW $t0, 96($a0)    
    // multiply-acccumulate
    MULT $t1, $s0
    MADD $t2, $s1
    MADD $t3, $s2
    MADD $t4, $s3
    MADD $t5, $a2
    MADD $t6, $a3
    MADD $t7, $a3
    MADD $t8, $a2
    MADD $t9, $s3
    MADD $v0, $s2
    MADD $v1, $s1
    MADD $t0, $s0
    
    // Left channel sample copy
    LW $t1, 56($a0)
    SW $t1, 24($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t1, $ac0, 23
    // save result to $a1 pointer
    SW $t1, 16($a1)

    // ********************** Right channel pass 1 *****************************
    // load 12 data samples 1
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 36($a0)
    LW $t5, 44($a0)
    LW $t6, 52($a0)
    LW $t7, 60($a0)
    LW $t8, 68($a0)
    LW $t9, 76($a0)
    LW $v0, 84($a0)
    LW $v1, 92($a0)
    // multiply-acccumulate
    MULT $t0, $s0
    MADD $t1, $s1
    MADD $t2, $s2
    MADD $t3, $s3
    MADD $t4, $a2
    MADD $t5, $a3
    MADD $t6, $a3
    MADD $t7, $a2
    MADD $t8, $s3
    MADD $t9, $s2
    MADD $v0, $s1
    MADD $v1, $s0
    
    // Right channel sample copy
    LW $t0, 52($a0)
    SW $t0, 12($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t0, $ac0, 23
    // save result to $a1 pointer
    SW $t0, 4($a1)
    
    // ********************** Right channel pass 2 *****************************
    // load next sample
    LW $t0, 100($a0)
    // multiply-acccumulate
    MULT $t1, $s0
    MADD $t2, $s1
    MADD $t3, $s2
    MADD $t4, $s3
    MADD $t5, $a2
    MADD $t6, $a3
    MADD $t7, $a3
    MADD $t8, $a2
    MADD $t9, $s3
    MADD $v0, $s2
    MADD $v1, $s1
    MADD $t0, $s0
    
    // Right channel sample copy
    LW $t1, 60($a0)
    SW $t1, 28($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t1, $ac0, 23
    // save result to $a1 pointer
    SW $t1, 20($a1)

    // restore data from stack
    LW $s0, 0($sp)
    LW $s1, 4($sp)
    LW $s2, 8($sp)
    LW $s3, 12($sp)
    ADDU $sp, $sp, 16
    // restore address pointer
    J $ra

    
    
    
    
    
    
    
    
    
    
    
    
    
/*
    fir3 - FIR x2 upsampler
     
    external declaration:     extern void fir3(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 4 dual channel samples, upsample and return 8 dual channel samples.
*/
fir3:    
    // load 4 coefficients
    LI $v0, -23216
    LI $v1, 213892
    LI $a2, -1026696
    LI $a3, 5030324
    
    // ********************** Left channel pass 1 ******************************
    // load 8 data samples
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 32($a0)
    LW $t5, 40($a0)
    LW $t6, 48($a0)
    LW $t7, 56($a0)
    // multiply-acccumulate
    MULT $t0, $v0
    MADD $t1, $v1
    MADD $t2, $a2
    MADD $t3, $a3
    MADD $t4, $a3
    MADD $t5, $a2
    MADD $t6, $v1
    MADD $t7, $v0
    
    // Left channel sample copy
    LW $t8, 32($a0)
    SW $t8, 8($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 0($a1)

    // ********************** Left channel pass 2 ******************************
    // load data sample
    LW $t0, 64($a0)
    // multiply-acccumulate
    MULT $t1, $v0
    MADD $t2, $v1
    MADD $t3, $a2
    MADD $t4, $a3
    MADD $t5, $a3
    MADD $t6, $a2
    MADD $t7, $v1
    MADD $t0, $v0
    
    // Left channel sample copy
    LW $t8, 40($a0)
    SW $t8, 24($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 16($a1)

    // ********************** Left channel pass 3 ******************************
    // load data sample
    LW $t1, 72($a0)
    // multiply-acccumulate
    MULT $t2, $v0
    MADD $t3, $v1
    MADD $t4, $a2
    MADD $t5, $a3
    MADD $t6, $a3
    MADD $t7, $a2
    MADD $t0, $v1
    MADD $t1, $v0
    
    // Left channel sample copy
    LW $t8, 48($a0)
    SW $t8, 40($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 32($a1)

    // ********************** Left channel pass 4 ******************************
    // load data sample
    LW $t2, 80($a0)
    // multiply-acccumulate
    MULT $t3, $v0
    MADD $t4, $v1
    MADD $t5, $a2
    MADD $t6, $a3
    MADD $t7, $a3
    MADD $t0, $a2
    MADD $t1, $v1
    MADD $t2, $v0
    
    // Left channel sample copy
    LW $t8, 56($a0)
    SW $t8, 56($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 48($a1)

    // ********************** Right channel pass 1 *****************************
    // load 8 data samples
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 36($a0)
    LW $t5, 44($a0)
    LW $t6, 52($a0)
    LW $t7, 60($a0)
    // multiply-acccumulate
    MULT $t0, $v0
    MADD $t1, $v1
    MADD $t2, $a2
    MADD $t3, $a3
    MADD $t4, $a3
    MADD $t5, $a2
    MADD $t6, $v1
    MADD $t7, $v0
    
    // Right channel sample copy
    LW $t8, 36($a0)
    SW $t8, 12($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 4($a1)

    // ********************** Right channel pass 2 *****************************
    // load data sample
    LW $t0, 68($a0)
    // multiply-acccumulate
    MULT $t1, $v0
    MADD $t2, $v1
    MADD $t3, $a2
    MADD $t4, $a3
    MADD $t5, $a3
    MADD $t6, $a2
    MADD $t7, $v1
    MADD $t0, $v0
    
    // Right channel sample copy
    LW $t8, 44($a0)
    SW $t8, 28($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 20($a1)

    // ********************** Right channel pass 3 *****************************
    // load data sample
    LW $t1, 76($a0)
    // multiply-acccumulate
    MULT $t2, $v0
    MADD $t3, $v1
    MADD $t4, $a2
    MADD $t5, $a3
    MADD $t6, $a3
    MADD $t7, $a2
    MADD $t0, $v1
    MADD $t1, $v0
    
    // Right channel sample copy
    LW $t8, 52($a0)
    SW $t8, 44($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 36($a1)

    // ********************** Right channel pass 4 *****************************
    // load data sample
    LW $t2, 84($a0)
    // multiply-acccumulate
    MULT $t3, $v0
    MADD $t4, $v1
    MADD $t5, $a2
    MADD $t6, $a3
    MADD $t7, $a3
    MADD $t0, $a2
    MADD $t1, $v1
    MADD $t2, $v0
    
    // Right channel sample copy
    LW $t8, 60($a0)
    SW $t8, 60($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $t8, $ac0, 23
    // save result to $a1 pointer
    SW $t8, 52($a1)

    // restore address pointer
    J $ra
    
    
    
    
    
    
    
    
    
    
    
    
/*
    fir4 - FIR x2 upsampler
     
    external declaration:     extern void fir4(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 8 dual channel samples, upsample and return 16 dual channel samples.
*/
fir4:
    // load 3 coefficients
    LI $t6, 98342
    LI $t7, -819316
    LI $t8, 4915278

    // ********************** Left channel pass 1 ******************************
    // load 6 data samples
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 32($a0)
    LW $t5, 40($a0)
    // multiply-acccumulate
    MULT $t0, $t6
    MADD $t1, $t7
    MADD $t2, $t8
    MADD $t3, $t8
    MADD $t4, $t7
    MADD $t5, $t6
    
    // Left channel sample copy
    LW $v1, 24($a0)
    SW $v1, 8($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 0($a1)

    // ********************** Left channel pass 2 ******************************
    // load data sample
    LW $t0, 48($a0)
    // multiply-acccumulate
    MULT $t1, $t6
    MADD $t2, $t7
    MADD $t3, $t8
    MADD $t4, $t8
    MADD $t5, $t7
    MADD $t0, $t6
    
    // Left channel sample copy
    LW $v1, 32($a0)
    SW $v1, 24($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 16($a1)

    // ********************** Left channel pass 3 ******************************
    // load data sample
    LW $t1, 56($a0)
    // multiply-acccumulate
    MULT $t2, $t6
    MADD $t3, $t7
    MADD $t4, $t8
    MADD $t5, $t8
    MADD $t0, $t7
    MADD $t1, $t6
    
    // Left channel sample copy
    LW $v1, 40($a0)
    SW $v1, 40($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 32($a1)

    // ********************** Left channel pass 4 ******************************
    // load data sample
    LW $t2, 64($a0)
    // multiply-acccumulate
    MULT $t3, $t6
    MADD $t4, $t7
    MADD $t5, $t8
    MADD $t0, $t8
    MADD $t1, $t7
    MADD $t2, $t6
    
    // Left channel sample copy
    LW $v1, 48($a0)
    SW $v1, 56($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 48($a1)

    // ********************** Left channel pass 5 ******************************
    // load data sample
    LW $t3, 72($a0)
    // multiply-acccumulate
    MULT $t4, $t6
    MADD $t5, $t7
    MADD $t0, $t8
    MADD $t1, $t8
    MADD $t2, $t7
    MADD $t3, $t6
    
    // Left channel sample copy
    LW $v1, 56($a0)
    SW $v1, 72($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 64($a1)

    // ********************** Left channel pass 6 ******************************
    // load data sample
    LW $t4, 80($a0)
    // multiply-acccumulate
    MULT $t5, $t6
    MADD $t0, $t7
    MADD $t1, $t8
    MADD $t2, $t8
    MADD $t3, $t7
    MADD $t4, $t6
    
    // Left channel sample copy
    LW $v1, 64($a0)
    SW $v1, 88($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 80($a1)

    // ********************** Left channel pass 7 ******************************
    // load data sample
    LW $t5, 88($a0)
    // multiply-acccumulate
    MULT $t0, $t6
    MADD $t1, $t7
    MADD $t2, $t8
    MADD $t3, $t8
    MADD $t4, $t7
    MADD $t5, $t6
    
    // Left channel sample copy
    LW $v1, 72($a0)
    SW $v1, 104($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 96($a1)

    // ********************** Left channel pass 8 ******************************
    // load data sample
    LW $t0, 96($a0)
    // multiply-acccumulate
    MULT $t1, $t6
    MADD $t2, $t7
    MADD $t3, $t8
    MADD $t4, $t8
    MADD $t5, $t7
    MADD $t0, $t6
    
    // Left channel sample copy
    LW $v1, 80($a0)
    SW $v1, 120($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 112($a1)

    // ********************** Right channel pass 1 *****************************
    // load 6 data samples
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 36($a0)
    LW $t5, 44($a0)
    // multiply-acccumulate
    MULT $t0, $t6
    MADD $t1, $t7
    MADD $t2, $t8
    MADD $t3, $t8
    MADD $t4, $t7
    MADD $t5, $t6
    
    // Right channel sample copy
    LW $v1, 28($a0)
    SW $v1, 12($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 4($a1)

    // ********************** Right channel pass 2 *****************************
    // load data sample
    LW $t0, 52($a0)
    // multiply-acccumulate
    MULT $t1, $t6
    MADD $t2, $t7
    MADD $t3, $t8
    MADD $t4, $t8
    MADD $t5, $t7
    MADD $t0, $t6
    
    // Right channel sample copy
    LW $v1, 36($a0)
    SW $v1, 28($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 20($a1)

    // ********************** Right channel pass 3 *****************************
    // load data sample
    LW $t1, 60($a0)
    // multiply-acccumulate
    MULT $t2, $t6
    MADD $t3, $t7
    MADD $t4, $t8
    MADD $t5, $t8
    MADD $t0, $t7
    MADD $t1, $t6
    
    // Right channel sample copy
    LW $v1, 44($a0)
    SW $v1, 44($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 36($a1)

    // ********************** Right channel pass 4 *****************************
    // load data sample
    LW $t2, 68($a0)
    // multiply-acccumulate
    MULT $t3, $t6
    MADD $t4, $t7
    MADD $t5, $t8
    MADD $t0, $t8
    MADD $t1, $t7
    MADD $t2, $t6
    
    // Right channel sample copy
    LW $v1, 52($a0)
    SW $v1, 60($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 52($a1)

    // ********************** Right channel pass 5 *****************************
    // load data sample
    LW $t3, 76($a0)
    // multiply-acccumulate
    MULT $t4, $t6
    MADD $t5, $t7
    MADD $t0, $t8
    MADD $t1, $t8
    MADD $t2, $t7
    MADD $t3, $t6
    
    // Right channel sample copy
    LW $v1, 60($a0)
    SW $v1, 76($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 68($a1)

    // ********************** Right channel pass 6 *****************************
    // load data sample
    LW $t4, 84($a0)
    // multiply-acccumulate
    MULT $t5, $t6
    MADD $t0, $t7
    MADD $t1, $t8
    MADD $t2, $t8
    MADD $t3, $t7
    MADD $t4, $t6
    
    // Right channel sample copy
    LW $v1, 68($a0)
    SW $v1, 92($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 84($a1)

    // ********************** Right channel pass 7 *****************************
    // load data sample
    LW $t5, 92($a0)
    // multiply-acccumulate
    MULT $t0, $t6
    MADD $t1, $t7
    MADD $t2, $t8
    MADD $t3, $t8
    MADD $t4, $t7
    MADD $t5, $t6
    
    // Right channel sample copy
    LW $v1, 76($a0)
    SW $v1, 108($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 100($a1)

    // ********************** Right channel pass 8 *****************************
    // load data sample
    LW $t0, 100($a0)
    // multiply-acccumulate
    MULT $t1, $t6
    MADD $t2, $t7
    MADD $t3, $t8
    MADD $t4, $t8
    MADD $t5, $t7
    MADD $t0, $t6
    
    // Right channel sample copy
    LW $v1, 84($a0)
    SW $v1, 124($a1)
    
    // Restore gain, round and get 32bit value
    EXTR_R.W $v0, $ac0, 23
    // save result to $a1 pointer
    SW $v0, 116($a1)

    // restore address pointer
    J $ra

    
    
    
    
    
    
    
    
    
    
    
    