
.global fir1_44L
.global fir1_44M
.global fir1_88
.global fir1_176
.global fir1_352
    
    
/*
    fir1L - FIR x2 upsampler
	with 12db attenuation to saturation
	-50db Nyquist Frequency attenuation
     
    external declaration:     extern void fir1_44L(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 1 dual channel sample, upsample and return 2 dual channel samples.
*/
fir1_44L:
    // ********************** FIR pass 1 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, 20
    LI $v1, -24
    LI $a2, 48
    LI $a3, -80
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 888($a0)
    LW $t5, 896($a0)
    LW $t6, 904($a0)
    LW $t7, 912($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 892($a0)
    LW $t5, 900($a0)
    LW $t6, 908($a0)
    LW $t7, 916($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, 128
    LI $v1, -192
    LI $a2, 276
    LI $a3, -380
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 856($a0)
    LW $t5, 864($a0)
    LW $t6, 872($a0)
    LW $t7, 880($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 860($a0)
    LW $t5, 868($a0)
    LW $t6, 876($a0)
    LW $t7, 884($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 3 -------------
    LI $v0, 496
    LI $v1, -628
    LI $a2, 760
    LI $a3, -880
    // load 8 data samples Left
    LW $t0, 64($a0)
    LW $t1, 72($a0)
    LW $t2, 80($a0)
    LW $t3, 88($a0)
    LW $t4, 824($a0)
    LW $t5, 832($a0)
    LW $t6, 840($a0)
    LW $t7, 848($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 68($a0)
    LW $t1, 76($a0)
    LW $t2, 84($a0)
    LW $t3, 92($a0)
    LW $t4, 828($a0)
    LW $t5, 836($a0)
    LW $t6, 844($a0)
    LW $t7, 852($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 4 -------------
    LI $v0, 972
    LI $v1, -1008
    LI $a2, 964
    LI $a3, -804
    // load 8 data samples Left
    LW $t0, 96($a0)
    LW $t1, 104($a0)
    LW $t2, 112($a0)
    LW $t3, 120($a0)
    LW $t4, 792($a0)
    LW $t5, 800($a0)
    LW $t6, 808($a0)
    LW $t7, 816($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 100($a0)
    LW $t1, 108($a0)
    LW $t2, 116($a0)
    LW $t3, 124($a0)
    LW $t4, 796($a0)
    LW $t5, 804($a0)
    LW $t6, 812($a0)
    LW $t7, 820($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 5 -------------
    LI $v0, 488
    LI $v1, 24
    LI $a2, -768
    LI $a3, 1784
    // load 8 data samples Left
    LW $t0, 128($a0)
    LW $t1, 136($a0)
    LW $t2, 144($a0)
    LW $t3, 152($a0)
    LW $t4, 760($a0)
    LW $t5, 768($a0)
    LW $t6, 776($a0)
    LW $t7, 784($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 132($a0)
    LW $t1, 140($a0)
    LW $t2, 148($a0)
    LW $t3, 156($a0)
    LW $t4, 764($a0)
    LW $t5, 772($a0)
    LW $t6, 780($a0)
    LW $t7, 788($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 6 -------------
    LI $v0, -3104
    LI $v1, 4744
    LI $a2, -6712
    LI $a3, 8996
    // load 8 data samples Left
    LW $t0, 160($a0)
    LW $t1, 168($a0)
    LW $t2, 176($a0)
    LW $t3, 184($a0)
    LW $t4, 728($a0)
    LW $t5, 736($a0)
    LW $t6, 744($a0)
    LW $t7, 752($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 164($a0)
    LW $t1, 172($a0)
    LW $t2, 180($a0)
    LW $t3, 188($a0)
    LW $t4, 732($a0)
    LW $t5, 740($a0)
    LW $t6, 748($a0)
    LW $t7, 756($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 7 -------------
    LI $v0, -11556
    LI $v1, 14328
    LI $a2, -17220
    LI $a3, 20096
    // load 8 data samples Left
    LW $t0, 192($a0)
    LW $t1, 200($a0)
    LW $t2, 208($a0)
    LW $t3, 216($a0)
    LW $t4, 696($a0)
    LW $t5, 704($a0)
    LW $t6, 712($a0)
    LW $t7, 720($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 196($a0)
    LW $t1, 204($a0)
    LW $t2, 212($a0)
    LW $t3, 220($a0)
    LW $t4, 700($a0)
    LW $t5, 708($a0)
    LW $t6, 716($a0)
    LW $t7, 724($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 8 -------------
    LI $v0, -22804
    LI $v1, 25148
    LI $a2, -26896
    LI $a3, 27808
    // load 8 data samples Left
    LW $t0, 224($a0)
    LW $t1, 232($a0)
    LW $t2, 240($a0)
    LW $t3, 248($a0)
    LW $t4, 664($a0)
    LW $t5, 672($a0)
    LW $t6, 680($a0)
    LW $t7, 688($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 228($a0)
    LW $t1, 236($a0)
    LW $t2, 244($a0)
    LW $t3, 252($a0)
    LW $t4, 668($a0)
    LW $t5, 676($a0)
    LW $t6, 684($a0)
    LW $t7, 692($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 9 -------------
    LI $v0, -27608
    LI $v1, 26012
    LI $a2, -22748
    LI $a3, 17536
    // load 8 data samples Left
    LW $t0, 256($a0)
    LW $t1, 264($a0)
    LW $t2, 272($a0)
    LW $t3, 280($a0)
    LW $t4, 632($a0)
    LW $t5, 640($a0)
    LW $t6, 648($a0)
    LW $t7, 656($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 260($a0)
    LW $t1, 268($a0)
    LW $t2, 276($a0)
    LW $t3, 284($a0)
    LW $t4, 636($a0)
    LW $t5, 644($a0)
    LW $t6, 652($a0)
    LW $t7, 660($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 10 -------------
    LI $v0, -10132
    LI $v1, 324
    LI $a2, 12048
    LI $a3, -27088
    // load 8 data samples Left
    LW $t0, 288($a0)
    LW $t1, 296($a0)
    LW $t2, 304($a0)
    LW $t3, 312($a0)
    LW $t4, 600($a0)
    LW $t5, 608($a0)
    LW $t6, 616($a0)
    LW $t7, 624($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 292($a0)
    LW $t1, 300($a0)
    LW $t2, 308($a0)
    LW $t3, 316($a0)
    LW $t4, 604($a0)
    LW $t5, 612($a0)
    LW $t6, 620($a0)
    LW $t7, 628($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 11 -------------
    LI $v0, 44820
    LI $v1, -65188
    LI $a2, 88056
    LI $a3, -113184
    // load 8 data samples Left
    LW $t0, 320($a0)
    LW $t1, 328($a0)
    LW $t2, 336($a0)
    LW $t3, 344($a0)
    LW $t4, 568($a0)
    LW $t5, 576($a0)
    LW $t6, 584($a0)
    LW $t7, 592($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 324($a0)
    LW $t1, 332($a0)
    LW $t2, 340($a0)
    LW $t3, 348($a0)
    LW $t4, 572($a0)
    LW $t5, 580($a0)
    LW $t6, 588($a0)
    LW $t7, 596($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 12 -------------
    LI $v0, 140244
    LI $v1, -168828
    LI $a2, 198444
    LI $a3, -228532
    // load 8 data samples Left
    LW $t0, 352($a0)
    LW $t1, 360($a0)
    LW $t2, 368($a0)
    LW $t3, 376($a0)
    LW $t4, 536($a0)
    LW $t5, 544($a0)
    LW $t6, 552($a0)
    LW $t7, 560($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 356($a0)
    LW $t1, 364($a0)
    LW $t2, 372($a0)
    LW $t3, 380($a0)
    LW $t4, 540($a0)
    LW $t5, 548($a0)
    LW $t6, 556($a0)
    LW $t7, 564($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 13 -------------
    LI $v0, 258480
    LI $v1, -287640
    LI $a2, 315352
    LI $a3, -340964
    // load 8 data samples Left
    LW $t0, 384($a0)
    LW $t1, 392($a0)
    LW $t2, 400($a0)
    LW $t3, 408($a0)
    LW $t4, 504($a0)
    LW $t5, 512($a0)
    LW $t6, 520($a0)
    LW $t7, 528($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 388($a0)
    LW $t1, 396($a0)
    LW $t2, 404($a0)
    LW $t3, 412($a0)
    LW $t4, 508($a0)
    LW $t5, 516($a0)
    LW $t6, 524($a0)
    LW $t7, 532($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 14 -------------
    LI $v0, 363848
    LI $v1, -383440
    LI $a2, 399232
    LI $a3, -410820
    // load 8 data samples Left
    LW $t0, 416($a0)
    LW $t1, 424($a0)
    LW $t2, 432($a0)
    LW $t3, 440($a0)
    LW $t4, 472($a0)
    LW $t5, 480($a0)
    LW $t6, 488($a0)
    LW $t7, 496($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 420($a0)
    LW $t1, 428($a0)
    LW $t2, 436($a0)
    LW $t3, 444($a0)
    LW $t4, 476($a0)
    LW $t5, 484($a0)
    LW $t6, 492($a0)
    LW $t7, 500($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0

    // ------------ load coefficients 15 -------------
    LI $v0, 417900
    LI $v1, 7968328
    // load 3 data samples Left
    LW $t0, 448($a0)
    LW $t1, 456($a0)
    LW $t2, 464($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $v0
    // load 3 data samples Right
    LW $t0, 452($a0)
    LW $t1, 460($a0)
    LW $t2, 468($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 0($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 4($a1)
    
    // ********************** FIR pass 2 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, 12
    LI $v1, -28
    LI $a2, 36
    LI $a3, -48
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 896($a0)
    LW $t5, 904($a0)
    LW $t6, 912($a0)
    LW $t7, 920($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 900($a0)
    LW $t5, 908($a0)
    LW $t6, 916($a0)
    LW $t7, 924($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, 56
    LI $v1, -56
    LI $a2, 44
    LI $a3, -12
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 864($a0)
    LW $t5, 872($a0)
    LW $t6, 880($a0)
    LW $t7, 888($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 868($a0)
    LW $t5, 876($a0)
    LW $t6, 884($a0)
    LW $t7, 892($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 3 -------------
    LI $v0, -48
    LI $v1, 152
    LI $a2, -308
    LI $a3, 528
    // load 8 data samples Left
    LW $t0, 64($a0)
    LW $t1, 72($a0)
    LW $t2, 80($a0)
    LW $t3, 88($a0)
    LW $t4, 832($a0)
    LW $t5, 840($a0)
    LW $t6, 848($a0)
    LW $t7, 856($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 68($a0)
    LW $t1, 76($a0)
    LW $t2, 84($a0)
    LW $t3, 92($a0)
    LW $t4, 836($a0)
    LW $t5, 844($a0)
    LW $t6, 852($a0)
    LW $t7, 860($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 4 -------------
    LI $v0, -824
    LI $v1, 1204
    LI $a2, -1676
    LI $a3, 2240
    // load 8 data samples Left
    LW $t0, 96($a0)
    LW $t1, 104($a0)
    LW $t2, 112($a0)
    LW $t3, 120($a0)
    LW $t4, 800($a0)
    LW $t5, 808($a0)
    LW $t6, 816($a0)
    LW $t7, 824($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 100($a0)
    LW $t1, 108($a0)
    LW $t2, 116($a0)
    LW $t3, 124($a0)
    LW $t4, 804($a0)
    LW $t5, 812($a0)
    LW $t6, 820($a0)
    LW $t7, 828($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 5 -------------
    LI $v0, -2884
    LI $v1, 3596
    LI $a2, -4340
    LI $a3, 5084
    // load 8 data samples Left
    LW $t0, 128($a0)
    LW $t1, 136($a0)
    LW $t2, 144($a0)
    LW $t3, 152($a0)
    LW $t4, 768($a0)
    LW $t5, 776($a0)
    LW $t6, 784($a0)
    LW $t7, 792($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 132($a0)
    LW $t1, 140($a0)
    LW $t2, 148($a0)
    LW $t3, 156($a0)
    LW $t4, 772($a0)
    LW $t5, 780($a0)
    LW $t6, 788($a0)
    LW $t7, 796($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 6 -------------
    LI $v0, -5764
    LI $v1, 6316
    LI $a2, -6652
    LI $a3, 6680
    // load 8 data samples Left
    LW $t0, 160($a0)
    LW $t1, 168($a0)
    LW $t2, 176($a0)
    LW $t3, 184($a0)
    LW $t4, 736($a0)
    LW $t5, 744($a0)
    LW $t6, 752($a0)
    LW $t7, 760($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 164($a0)
    LW $t1, 172($a0)
    LW $t2, 180($a0)
    LW $t3, 188($a0)
    LW $t4, 740($a0)
    LW $t5, 748($a0)
    LW $t6, 756($a0)
    LW $t7, 764($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 7 -------------
    LI $v0, -6292
    LI $v1, 5380
    LI $a2, -3824
    LI $a3, 1520
    // load 8 data samples Left
    LW $t0, 192($a0)
    LW $t1, 200($a0)
    LW $t2, 208($a0)
    LW $t3, 216($a0)
    LW $t4, 704($a0)
    LW $t5, 712($a0)
    LW $t6, 720($a0)
    LW $t7, 728($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 196($a0)
    LW $t1, 204($a0)
    LW $t2, 212($a0)
    LW $t3, 220($a0)
    LW $t4, 708($a0)
    LW $t5, 716($a0)
    LW $t6, 724($a0)
    LW $t7, 732($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 8 -------------
    LI $v0, 1620
    LI $v1, -5680
    LI $a2, 10696
    LI $a3, -16680
    // load 8 data samples Left
    LW $t0, 224($a0)
    LW $t1, 232($a0)
    LW $t2, 240($a0)
    LW $t3, 248($a0)
    LW $t4, 672($a0)
    LW $t5, 680($a0)
    LW $t6, 688($a0)
    LW $t7, 696($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 228($a0)
    LW $t1, 236($a0)
    LW $t2, 244($a0)
    LW $t3, 252($a0)
    LW $t4, 676($a0)
    LW $t5, 684($a0)
    LW $t6, 692($a0)
    LW $t7, 700($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 9 -------------
    LI $v0, 23592
    LI $v1, -31332
    LI $a2, 39748
    LI $a3, -48616
    // load 8 data samples Left
    LW $t0, 256($a0)
    LW $t1, 264($a0)
    LW $t2, 272($a0)
    LW $t3, 280($a0)
    LW $t4, 640($a0)
    LW $t5, 648($a0)
    LW $t6, 656($a0)
    LW $t7, 664($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
     // load 8 data samples Right
    LW $t0, 260($a0)
    LW $t1, 268($a0)
    LW $t2, 276($a0)
    LW $t3, 284($a0)
    LW $t4, 644($a0)
    LW $t5, 652($a0)
    LW $t6, 660($a0)
    LW $t7, 668($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 10 -------------
    LI $v0, 57648
    LI $v1, -66476
    LI $a2, 74668
    LI $a3, -81720
    // load 8 data samples Left
    LW $t0, 288($a0)
    LW $t1, 296($a0)
    LW $t2, 304($a0)
    LW $t3, 312($a0)
    LW $t4, 608($a0)
    LW $t5, 616($a0)
    LW $t6, 624($a0)
    LW $t7, 632($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 292($a0)
    LW $t1, 300($a0)
    LW $t2, 308($a0)
    LW $t3, 316($a0)
    LW $t4, 612($a0)
    LW $t5, 620($a0)
    LW $t6, 628($a0)
    LW $t7, 636($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 11 -------------
    LI $v0, 87072
    LI $v1, -90096
    LI $a2, 90116
    LI $a3, -86400
    // load 8 data samples Left
    LW $t0, 320($a0)
    LW $t1, 328($a0)
    LW $t2, 336($a0)
    LW $t3, 344($a0)
    LW $t4, 576($a0)
    LW $t5, 584($a0)
    LW $t6, 592($a0)
    LW $t7, 600($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 324($a0)
    LW $t1, 332($a0)
    LW $t2, 340($a0)
    LW $t3, 348($a0)
    LW $t4, 580($a0)
    LW $t5, 588($a0)
    LW $t6, 596($a0)
    LW $t7, 604($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 12 -------------
    LI $v0, 78172
    LI $v1, -64588
    LI $a2, 44712
    LI $a3, -17464
    // load 8 data samples Left
    LW $t0, 352($a0)
    LW $t1, 360($a0)
    LW $t2, 368($a0)
    LW $t3, 376($a0)
    LW $t4, 544($a0)
    LW $t5, 552($a0)
    LW $t6, 560($a0)
    LW $t7, 568($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 356($a0)
    LW $t1, 364($a0)
    LW $t2, 372($a0)
    LW $t3, 380($a0)
    LW $t4, 548($a0)
    LW $t5, 556($a0)
    LW $t6, 564($a0)
    LW $t7, 572($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 13 -------------
    LI $v0, -18472
    LI $v1, 64848
    LI $a2, -124164
    LI $a3, 200372
    // load 8 data samples Left
    LW $t0, 384($a0)
    LW $t1, 392($a0)
    LW $t2, 400($a0)
    LW $t3, 408($a0)
    LW $t4, 512($a0)
    LW $t5, 520($a0)
    LW $t6, 528($a0)
    LW $t7, 536($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 388($a0)
    LW $t1, 396($a0)
    LW $t2, 404($a0)
    LW $t3, 412($a0)
    LW $t4, 516($a0)
    LW $t5, 524($a0)
    LW $t6, 532($a0)
    LW $t7, 540($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 14 -------------
    LI $v0, -300264
    LI $v1, 436752
    LI $a2, -637844
    LI $a3, 976956
    // load 8 data samples Left
    LW $t0, 416($a0)
    LW $t1, 424($a0)
    LW $t2, 432($a0)
    LW $t3, 440($a0)
    LW $t4, 480($a0)
    LW $t5, 488($a0)
    LW $t6, 496($a0)
    LW $t7, 504($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 420($a0)
    LW $t1, 428($a0)
    LW $t2, 436($a0)
    LW $t3, 444($a0)
    LW $t4, 484($a0)
    LW $t5, 492($a0)
    LW $t6, 500($a0)
    LW $t7, 508($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 15 -------------
    LI $v0, -1724724
    LI $v1, 5321768
     // load 4 data samples Left
    LW $t0, 448($a0)
    LW $t1, 456($a0)
    LW $t2, 464($a0)
    LW $t3, 472($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $v1
    MADD $ac0, $t3, $v0
     // load 4 data samples Right
    LW $t0, 452($a0)
    LW $t1, 460($a0)
    LW $t2, 468($a0)
    LW $t3, 476($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $v1
    MADD $ac1, $t3, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 8($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 12($a1)
    
    // restore address pointer
    J $ra
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
/*
    fir1_44M - FIR x2 upsampler
	with 12db attenuation to saturation
	-33db Nyquist Frequency attenuation
     
    external declaration:     extern void fir1_44M(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 1 dual channel sample, upsample and return 2 dual channel samples.
*/
fir1_44M:    
    // ********************** FIR pass 1 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, 8
    LI $v1, -4
    //LI $a2, 0 // cut zero coefficient
    LI $a3, 20
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    //LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 760($a0)
    //LW $t5, 768($a0)
    LW $t6, 776($a0)
    LW $t7, 784($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    //MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    //MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    //LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 764($a0)
    //LW $t5, 772($a0)
    LW $t6, 780($a0)
    LW $t7, 788($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    //MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
   // MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, -56
    LI $v1, 120
    LI $a2, -224
    LI $a3, 380
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 728($a0)
    LW $t5, 736($a0)
    LW $t6, 744($a0)
    LW $t7, 752($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 732($a0)
    LW $t5, 740($a0)
    LW $t6, 748($a0)
    LW $t7, 756($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 3 -------------
    LI $v0, -600
    LI $v1, 908
    LI $a2, -1308
    LI $a3, 1816
    // load 8 data samples Left
    LW $t0, 64($a0)
    LW $t1, 72($a0)
    LW $t2, 80($a0)
    LW $t3, 88($a0)
    LW $t4, 696($a0)
    LW $t5, 704($a0)
    LW $t6, 712($a0)
    LW $t7, 720($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 68($a0)
    LW $t1, 76($a0)
    LW $t2, 84($a0)
    LW $t3, 92($a0)
    LW $t4, 700($a0)
    LW $t5, 708($a0)
    LW $t6, 716($a0)
    LW $t7, 724($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 4 -------------
    LI $v0, -2444
    LI $v1, 3192
    LI $a2, -4048
    LI $a3, 5000
    // load 8 data samples Left
    LW $t0, 96($a0)
    LW $t1, 104($a0)
    LW $t2, 112($a0)
    LW $t3, 120($a0)
    LW $t4, 664($a0)
    LW $t5, 672($a0)
    LW $t6, 680($a0)
    LW $t7, 688($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 100($a0)
    LW $t1, 108($a0)
    LW $t2, 116($a0)
    LW $t3, 124($a0)
    LW $t4, 668($a0)
    LW $t5, 676($a0)
    LW $t6, 684($a0)
    LW $t7, 692($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 5 -------------
    LI $v0, -6012
    LI $v1, 7028
    LI $a2, -7988
    LI $a3, 8796
    // load 8 data samples Left
    LW $t0, 128($a0)
    LW $t1, 136($a0)
    LW $t2, 144($a0)
    LW $t3, 152($a0)
    LW $t4, 632($a0)
    LW $t5, 640($a0)
    LW $t6, 648($a0)
    LW $t7, 656($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 132($a0)
    LW $t1, 140($a0)
    LW $t2, 148($a0)
    LW $t3, 156($a0)
    LW $t4, 636($a0)
    LW $t5, 644($a0)
    LW $t6, 652($a0)
    LW $t7, 660($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 6 -------------
    LI $v0, -9340
    LI $v1, 9492
    LI $a2, -9092
    LI $a3, 7972
    // load 8 data samples Left
    LW $t0, 160($a0)
    LW $t1, 168($a0)
    LW $t2, 176($a0)
    LW $t3, 184($a0)
    LW $t4, 600($a0)
    LW $t5, 608($a0)
    LW $t6, 616($a0)
    LW $t7, 624($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 164($a0)
    LW $t1, 172($a0)
    LW $t2, 180($a0)
    LW $t3, 188($a0)
    LW $t4, 604($a0)
    LW $t5, 612($a0)
    LW $t6, 620($a0)
    LW $t7, 628($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 7 -------------
    LI $v0, -5956
    LI $v1, 2844
    LI $a2, 1552
    LI $a3, -7408
    // load 8 data samples Left
    LW $t0, 192($a0)
    LW $t1, 200($a0)
    LW $t2, 208($a0)
    LW $t3, 216($a0)
    LW $t4, 568($a0)
    LW $t5, 576($a0)
    LW $t6, 584($a0)
    LW $t7, 592($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 196($a0)
    LW $t1, 204($a0)
    LW $t2, 212($a0)
    LW $t3, 220($a0)
    LW $t4, 572($a0)
    LW $t5, 580($a0)
    LW $t6, 588($a0)
    LW $t7, 596($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 8 -------------
    LI $v0, 14900
    LI $v1, -24160
    LI $a2, 35300
    LI $a3, -48384
    // load 8 data samples Left
    LW $t0, 224($a0)
    LW $t1, 232($a0)
    LW $t2, 240($a0)
    LW $t3, 248($a0)
    LW $t4, 536($a0)
    LW $t5, 544($a0)
    LW $t6, 552($a0)
    LW $t7, 560($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 228($a0)
    LW $t1, 236($a0)
    LW $t2, 244($a0)
    LW $t3, 252($a0)
    LW $t4, 540($a0)
    LW $t5, 548($a0)
    LW $t6, 556($a0)
    LW $t7, 564($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 9 -------------
    LI $v0, 63416
    LI $v1, -80348
    LI $a2, 99068
    LI $a3, -119396
    // load 8 data samples Left
    LW $t0, 256($a0)
    LW $t1, 264($a0)
    LW $t2, 272($a0)
    LW $t3, 280($a0)
    LW $t4, 504($a0)
    LW $t5, 512($a0)
    LW $t6, 520($a0)
    LW $t7, 528($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 260($a0)
    LW $t1, 268($a0)
    LW $t2, 276($a0)
    LW $t3, 284($a0)
    LW $t4, 508($a0)
    LW $t5, 516($a0)
    LW $t6, 524($a0)
    LW $t7, 532($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 10 -------------
    LI $v0, 141084
    LI $v1, -163820
    LI $a2, 187232
    LI $a3, -210904
    // load 8 data samples Left
    LW $t0, 288($a0)
    LW $t1, 296($a0)
    LW $t2, 304($a0)
    LW $t3, 312($a0)
    LW $t4, 472($a0)
    LW $t5, 480($a0)
    LW $t6, 488($a0)
    LW $t7, 496($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 292($a0)
    LW $t1, 300($a0)
    LW $t2, 308($a0)
    LW $t3, 316($a0)
    LW $t4, 476($a0)
    LW $t5, 484($a0)
    LW $t6, 492($a0)
    LW $t7, 500($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 11 -------------
    LI $v0, 234372
    LI $v1, -257152
    LI $a2, 278744
    LI $a3, -298664
    // load 8 data samples Left
    LW $t0, 320($a0)
    LW $t1, 328($a0)
    LW $t2, 336($a0)
    LW $t3, 344($a0)
    LW $t4, 440($a0)
    LW $t5, 448($a0)
    LW $t6, 456($a0)
    LW $t7, 464($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 324($a0)
    LW $t1, 332($a0)
    LW $t2, 340($a0)
    LW $t3, 348($a0)
    LW $t4, 444($a0)
    LW $t5, 452($a0)
    LW $t6, 460($a0)
    LW $t7, 468($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 12 -------------
    LI $v0, 316432
    LI $v1, -331624
    LI $a2, 343860
    LI $a3, -352832
    // load 8 data samples Left
    LW $t0, 352($a0)
    LW $t1, 360($a0)
    LW $t2, 368($a0)
    LW $t3, 376($a0)
    LW $t4, 408($a0)
    LW $t5, 416($a0)
    LW $t6, 424($a0)
    LW $t7, 432($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 356($a0)
    LW $t1, 364($a0)
    LW $t2, 372($a0)
    LW $t3, 380($a0)
    LW $t4, 412($a0)
    LW $t5, 420($a0)
    LW $t6, 428($a0)
    LW $t7, 436($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 13 -------------
    LI $v0, 358312
    LI $v1, 8028456
    // load 3 data samples Left
    LW $t0, 384($a0)
    LW $t1, 392($a0)
    LW $t2, 400($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $v0
    // load 3 data samples Right
    LW $t0, 388($a0)
    LW $t1, 396($a0)
    LW $t2, 404($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 0($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 4($a1)
    
    // ********************** FIR pass 2 ******************************   
    // ------------ load coefficients 1 -------------
    LI $v0, -24
    LI $v1, 40
    LI $a2, -68
    LI $a3, 116
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 768($a0)
    LW $t5, 776($a0)
    LW $t6, 784($a0)
    LW $t7, 792($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 772($a0)
    LW $t5, 780($a0)
    LW $t6, 788($a0)
    LW $t7, 796($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, -172
    LI $v1, 248
    LI $a2, -336
    LI $a3, 444
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 736($a0)
    LW $t5, 744($a0)
    LW $t6, 752($a0)
    LW $t7, 760($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 740($a0)
    LW $t5, 748($a0)
    LW $t6, 756($a0)
    LW $t7, 764($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 3 -------------
    LI $v0, -552
    LI $v1, 652
    LI $a2, -732
    LI $a3, 764
    // load 8 data samples Left
    LW $t0, 64($a0)
    LW $t1, 72($a0)
    LW $t2, 80($a0)
    LW $t3, 88($a0)
    LW $t4, 704($a0)
    LW $t5, 712($a0)
    LW $t6, 720($a0)
    LW $t7, 728($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 68($a0)
    LW $t1, 76($a0)
    LW $t2, 84($a0)
    LW $t3, 92($a0)
    LW $t4, 708($a0)
    LW $t5, 716($a0)
    LW $t6, 724($a0)
    LW $t7, 732($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 4 -------------
    LI $v0, -712
    LI $v1, 548
    LI $a2, -216
    LI $a3, -332
    // load 8 data samples Left
    LW $t0, 96($a0)
    LW $t1, 104($a0)
    LW $t2, 112($a0)
    LW $t3, 120($a0)
    LW $t4, 672($a0)
    LW $t5, 680($a0)
    LW $t6, 688($a0)
    LW $t7, 696($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 100($a0)
    LW $t1, 108($a0)
    LW $t2, 116($a0)
    LW $t3, 124($a0)
    LW $t4, 676($a0)
    LW $t5, 684($a0)
    LW $t6, 692($a0)
    LW $t7, 700($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 5 -------------
    LI $v0, 1156
    LI $v1, -2308
    LI $a2, 3860
    LI $a3, -5856
    // load 8 data samples Left
    LW $t0, 128($a0)
    LW $t1, 136($a0)
    LW $t2, 144($a0)
    LW $t3, 152($a0)
    LW $t4, 640($a0)
    LW $t5, 648($a0)
    LW $t6, 656($a0)
    LW $t7, 664($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 132($a0)
    LW $t1, 140($a0)
    LW $t2, 148($a0)
    LW $t3, 156($a0)
    LW $t4, 644($a0)
    LW $t5, 652($a0)
    LW $t6, 660($a0)
    LW $t7, 668($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 6 -------------
    LI $v0, 8344
    LI $v1, -11356
    LI $a2, 14904
    LI $a3, -18968
    // load 8 data samples Left
    LW $t0, 160($a0)
    LW $t1, 168($a0)
    LW $t2, 176($a0)
    LW $t3, 184($a0)
    LW $t4, 608($a0)
    LW $t5, 616($a0)
    LW $t6, 624($a0)
    LW $t7, 632($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 164($a0)
    LW $t1, 172($a0)
    LW $t2, 180($a0)
    LW $t3, 188($a0)
    LW $t4, 612($a0)
    LW $t5, 620($a0)
    LW $t6, 628($a0)
    LW $t7, 636($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 7 -------------
    LI $v0, 23500
    LI $v1, -28408
    LI $a2, 33568
    LI $a3, -38796
    // load 8 data samples Left
    LW $t0, 192($a0)
    LW $t1, 200($a0)
    LW $t2, 208($a0)
    LW $t3, 216($a0)
    LW $t4, 576($a0)
    LW $t5, 584($a0)
    LW $t6, 592($a0)
    LW $t7, 600($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 196($a0)
    LW $t1, 204($a0)
    LW $t2, 212($a0)
    LW $t3, 220($a0)
    LW $t4, 580($a0)
    LW $t5, 588($a0)
    LW $t6, 596($a0)
    LW $t7, 604($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 8 -------------
    LI $v0, 43856
    LI $v1, -48472
    LI $a2, 52300
    LI $a3, -54944
    // load 8 data samples Left
    LW $t0, 224($a0)
    LW $t1, 232($a0)
    LW $t2, 240($a0)
    LW $t3, 248($a0)
    LW $t4, 544($a0)
    LW $t5, 552($a0)
    LW $t6, 560($a0)
    LW $t7, 568($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 228($a0)
    LW $t1, 236($a0)
    LW $t2, 244($a0)
    LW $t3, 252($a0)
    LW $t4, 548($a0)
    LW $t5, 556($a0)
    LW $t6, 564($a0)
    LW $t7, 572($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 9 -------------
    LI $v0, 55968
    LI $v1, -54868
    LI $a2, 51108
    LI $a3, -44080
    // load 8 data samples Left
    LW $t0, 256($a0)
    LW $t1, 264($a0)
    LW $t2, 272($a0)
    LW $t3, 280($a0)
    LW $t4, 512($a0)
    LW $t5, 520($a0)
    LW $t6, 528($a0)
    LW $t7, 536($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
     // load 8 data samples Right
    LW $t0, 260($a0)
    LW $t1, 268($a0)
    LW $t2, 276($a0)
    LW $t3, 284($a0)
    LW $t4, 516($a0)
    LW $t5, 524($a0)
    LW $t6, 532($a0)
    LW $t7, 540($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 10 -------------
    LI $v0, 33140
    LI $v1, -17552
    LI $a2, -3520
    LI $a3, 31076
    // load 8 data samples Left
    LW $t0, 288($a0)
    LW $t1, 296($a0)
    LW $t2, 304($a0)
    LW $t3, 312($a0)
    LW $t4, 480($a0)
    LW $t5, 488($a0)
    LW $t6, 496($a0)
    LW $t7, 504($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 292($a0)
    LW $t1, 300($a0)
    LW $t2, 308($a0)
    LW $t3, 316($a0)
    LW $t4, 484($a0)
    LW $t5, 492($a0)
    LW $t6, 500($a0)
    LW $t7, 508($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 11 -------------
    LI $v0, -66372
    LI $v1, 111124
    LI $a2, -167844
    LI $a3, 240496
    // load 8 data samples Left
    LW $t0, 320($a0)
    LW $t1, 328($a0)
    LW $t2, 336($a0)
    LW $t3, 344($a0)
    LW $t4, 448($a0)
    LW $t5, 456($a0)
    LW $t6, 464($a0)
    LW $t7, 472($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 324($a0)
    LW $t1, 332($a0)
    LW $t2, 340($a0)
    LW $t3, 348($a0)
    LW $t4, 452($a0)
    LW $t5, 460($a0)
    LW $t6, 468($a0)
    LW $t7, 476($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 12 -------------
    LI $v0, -335932
    LI $v1, 467152
    LI $a2, -662268
    LI $a3, 994832
    // load 8 data samples Left
    LW $t0, 352($a0)
    LW $t1, 360($a0)
    LW $t2, 368($a0)
    LW $t3, 376($a0)
    LW $t4, 416($a0)
    LW $t5, 424($a0)
    LW $t6, 432($a0)
    LW $t7, 440($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 356($a0)
    LW $t1, 364($a0)
    LW $t2, 372($a0)
    LW $t3, 380($a0)
    LW $t4, 420($a0)
    LW $t5, 428($a0)
    LW $t6, 436($a0)
    LW $t7, 444($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 13 -------------
    LI $v0, -1735624
    LI $v1, 5325428
     // load 4 data samples Left
    LW $t0, 384($a0)
    LW $t1, 392($a0)
    LW $t2, 400($a0)
    LW $t3, 408($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $v1
    MADD $ac0, $t3, $v0
     // load 4 data samples Right
    LW $t0, 388($a0)
    LW $t1, 396($a0)
    LW $t2, 404($a0)
    LW $t3, 412($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $v1
    MADD $ac1, $t3, $v0
    
    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 8($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 12($a1)
    
    // restore address pointer
    J $ra

    
    
    
    
    
    
    
    
    
/*
    fir1_88 - FIR x2 upsampler
	with 12db attenuation to saturation
	Full Nyquist Frequency attenuation
     
    external declaration:     extern void fir1_88(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 1 dual channel sample, upsample and return 2 dual channel samples.
*/
fir1_88:    
    // ********************** FIR pass 1 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, -272
    LI $v1, 2584
    LI $a2, -5728
    LI $a3, -7704
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 144($a0)
    LW $t5, 152($a0)
    LW $t6, 160($a0)
    LW $t7, 168($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 148($a0)
    LW $t5, 156($a0)
    LW $t6, 164($a0)
    LW $t7, 172($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, 58264
    LI $v1, -94632
    LI $a2, -41408
    LI $a3, 417544
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 112($a0)
    LW $t5, 120($a0)
    LW $t6, 128($a0)
    LW $t7, 136($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 116($a0)
    LW $t5, 124($a0)
    LW $t6, 132($a0)
    LW $t7, 140($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0

    // ------------ load coefficients 3 -------------
    LI $v0, -670128
    LI $v1, -88032
    LI $a2, 4623816
    // load 3 data samples Left
    LW $t0, 64($a0)
    LW $t1, 72($a0)
    LW $t2, 80($a0)
    LW $t3, 88($a0)
    LW $t4, 96($a0)
    LW $t5, 104($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a2
    MADD $ac0, $t4, $v1
    MADD $ac0, $t5, $v0
    // load 3 data samples Right
    LW $t0, 68($a0)
    LW $t1, 76($a0)
    LW $t2, 84($a0)
    LW $t3, 92($a0)
    LW $t4, 100($a0)
    LW $t5, 108($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a2
    MADD $ac1, $t4, $v1
    MADD $ac1, $t5, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 0($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 4($a1)
    
    
    // ********************** FIR pass 2 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, -168
    LI $v1, 632
    LI $a2, 1992
    LI $a3, -15328
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 152($a0)
    LW $t5, 160($a0)
    LW $t6, 168($a0)
    LW $t7, 176($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 156($a0)
    LW $t5, 164($a0)
    LW $t6, 172($a0)
    LW $t7, 180($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, 27664
    LI $v1, 20496
    LI $a2, -169016
    LI $a3, 262576
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 120($a0)
    LW $t5, 128($a0)
    LW $t6, 136($a0)
    LW $t7, 144($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 124($a0)
    LW $t5, 132($a0)
    LW $t6, 140($a0)
    LW $t7, 148($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0

    // ------------ load coefficients 3 -------------
    LI $v0, 66720
    LI $v1, -1015632
    LI $a2, 2169952
    LI $a3, 5688832
    // load 8 data samples Left
    LW $t0, 64($a0)
    LW $t1, 72($a0)
    LW $t2, 80($a0)
    LW $t3, 88($a0)
    LW $t4, 96($a0)
    LW $t5, 104($a0)
    LW $t6, 112($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a2
    MADD $ac0, $t5, $v1
    MADD $ac0, $t6, $v0
    // load 8 data samples Right
    LW $t0, 68($a0)
    LW $t1, 76($a0)
    LW $t2, 84($a0)
    LW $t3, 92($a0)
    LW $t4, 100($a0)
    LW $t5, 108($a0)
    LW $t6, 116($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a2
    MADD $ac1, $t5, $v1
    MADD $ac1, $t6, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 8($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 12($a1)
    
    // restore address pointer
    J $ra
    
    
    
    
    
    
    
    
    
    
    
    
    
    
/*
    fir1_176 - FIR x2 upsampler
	with 12db attenuation to saturation
	Full Nyquist Frequency attenuation
     
    external declaration:     extern void fir1_176(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 1 dual channel sample, upsample and return 2 dual channel samples.
*/
fir1_176:
    // ********************** FIR pass 1 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, -2924
    LI $v1, -7852
    LI $a2, 56116
    LI $a3, 64084
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 88($a0)
    LW $t5, 96($a0)
    LW $t6, 104($a0)
    LW $t7, 112($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 92($a0)
    LW $t5, 100($a0)
    LW $t6, 108($a0)
    LW $t7, 116($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, -411744
    LI $v1, -187888
    LI $a2, 2455700
    LI $a3, 4457624
    // load 7 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 64($a0)
    LW $t5, 72($a0)
    LW $t6, 80($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a2
    MADD $ac0, $t5, $v1
    MADD $ac0, $t6, $v0
    // load 7 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 68($a0)
    LW $t5, 76($a0)
    LW $t6, 84($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a2
    MADD $ac1, $t5, $v1
    MADD $ac1, $t6, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 0($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 4($a1)
    
    
    // ********************** FIR pass 2 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, -508
    LI $v1, -7488
    LI $a2, 10644
    LI $a3, 99760
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 96($a0)
    LW $t5, 104($a0)
    LW $t6, 112($a0)
    LW $t7, 120($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 100($a0)
    LW $t5, 108($a0)
    LW $t6, 116($a0)
    LW $t7, 124($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, -122856
    LI $v1, -553476
    LI $a2, 887736
    LI $a3, 3880492
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    LW $t2, 48($a0)
    LW $t3, 56($a0)
    LW $t4, 64($a0)
    LW $t5, 72($a0)
    LW $t6, 80($a0)
    LW $t7, 88($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    LW $t2, 52($a0)
    LW $t3, 60($a0)
    LW $t4, 68($a0)
    LW $t5, 76($a0)
    LW $t6, 84($a0)
    LW $t7, 92($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0

    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 8($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 12($a1)

    // restore address pointer
    J $ra

   
    
    
    
    
    
    
    
    
    
    
    
    
/*
    fir1_352 - FIR x2 upsampler
	with 12db attenuation to saturation
	-50db Nyquist Frequency attenuation
     
    external declaration:     extern void fir1_352(void *pSrc, void *pDst);

    input:
    pSrc - int32 source data pointer ($a0)

    output:
    pDst - int32 result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
    Function read 1 dual channel sample, upsample and return 2 dual channel samples.
*/
fir1_352:
    // ********************** FIR pass 1 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, -23456
    LI $v1, -213888
    LI $a2, 4224
    LI $a3, 2300336
    LI $t9, 4254176
    // load 9 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 32($a0)
    LW $t5, 40($a0)
    LW $t6, 48($a0)
    LW $t7, 56($a0)
    LW $t8, 64($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $t9
    MADD $ac0, $t5, $a3
    MADD $ac0, $t6, $a2
    MADD $ac0, $t7, $v1
    MADD $ac0, $t8, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 36($a0)
    LW $t5, 44($a0)
    LW $t6, 52($a0)
    LW $t7, 60($a0)
    LW $t8, 68($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $t9
    MADD $ac1, $t5, $a3
    MADD $ac1, $t6, $a2
    MADD $ac1, $t7, $v1
    MADD $ac1, $t8, $v0
    
    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 0($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 4($a1)
    
    
    // ********************** FIR pass 2 ******************************
    // ------------ load coefficients 1 -------------
    LI $v0, -2800
    LI $v1, -92352
    LI $a2, -273168
    LI $a3, 885808
    // load 8 data samples Left
    LW $t0, 0($a0)
    LW $t1, 8($a0)
    LW $t2, 16($a0)
    LW $t3, 24($a0)
    LW $t4, 48($a0)
    LW $t5, 56($a0)
    LW $t6, 64($a0)
    LW $t7, 72($a0)
    // multiply-acccumulate Left
    MULT $ac0, $t0, $v0
    MADD $ac0, $t1, $v1
    MADD $ac0, $t2, $a2
    MADD $ac0, $t3, $a3
    MADD $ac0, $t4, $a3
    MADD $ac0, $t5, $a2
    MADD $ac0, $t6, $v1
    MADD $ac0, $t7, $v0
    // load 8 data samples Right
    LW $t0, 4($a0)
    LW $t1, 12($a0)
    LW $t2, 20($a0)
    LW $t3, 28($a0)
    LW $t4, 52($a0)
    LW $t5, 60($a0)
    LW $t6, 68($a0)
    LW $t7, 76($a0)
    // multiply-acccumulate Right
    MULT $ac1, $t0, $v0
    MADD $ac1, $t1, $v1
    MADD $ac1, $t2, $a2
    MADD $ac1, $t3, $a3
    MADD $ac1, $t4, $a3
    MADD $ac1, $t5, $a2
    MADD $ac1, $t6, $v1
    MADD $ac1, $t7, $v0
    
    // ------------ load coefficients 2 -------------
    LI $v0, 3676816
    // load 8 data samples Left
    LW $t0, 32($a0)
    LW $t1, 40($a0)
    // multiply-acccumulate Left
    MADD $ac0, $t0, $v0
    MADD $ac0, $t1, $v0
    // load 8 data samples Right
    LW $t0, 36($a0)
    LW $t1, 44($a0)
    // multiply-acccumulate Right
    MADD $ac1, $t0, $v0
    MADD $ac1, $t1, $v0
    
    // round and save result Left
    EXTR_R.W $v0, $ac0, 25
    SW $v0, 8($a1)
    // round and save result Right
    EXTR_R.W $v1, $ac1, 25
    SW $v1, 12($a1)
    
    // restore address pointer
    J $ra
    
    
    
    
    
    
    
    
    
    
    
    
