#ifndef _DMA_H_    /* Guard against multiple inclusion */
#define _DMA_H_


/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */

/* This section lists the other files that are included in this file.
 */

/* TODO:  Include other files here if needed. */


/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

#define _DMA_SUSPEND_ALL()                          {   DMACONbits.SUSPEND = 1;\
                                                        while (DMACONbits.DMABUSY); }
#define _DMA_RESUME_ALL()                               DMACONbits.SUSPEND = 0

/******************* Output transfer defines *******************************/
#define _DMA_OutputSourceAddress_Set(adr)           {   DCH4SSA = adr; DCH5DSA = adr; }
#define DMA_OUTPUT_TRANSFET_PTR                         DCH4SPTR
    
/******************* Input transfer defines ********************************/   
#define _DMA_InputDestinationAddress_Set(adr)           DCH6DSA = adr
#define _DMA_Input_Transfer_Start()                     DCH6CONbits.CHEN = 1
#define _DMA_Input_Transfer_Size_Set(len)               DCH6DSIZ = len    
#define _DMA_Input_Transfer_Stop()                  {   if (DCH6CONbits.CHEN) {\
                                                        DCH6ECONbits.CABORT = 1; } }    
#define DMA_INPUT_TRANSFET_PTR                          DCH6DPTR

/******************* DSP transfer defines **********************************/    
#define _DMA_DSP_Start(ssa, ssz, dsa, dsz)              DCH7SSA = ssa;\
                                                        DCH7DSA = dsa;\
                                                        DCH7SSIZ = ssz;\
                                                        DCH7DSIZ = dsz;\
                                                        DCH7CSIZ = dsz;\
                                                        DCH7ECONbits.CFORCE = 1
    
#define _DMA_DSP_BusyCheck()                            DCH7CONbits.CHEDET
    
    

// DMA initialization
void dma_init (void);

// DMA control
void dma_series_output_start (void);
void dma_parallel_output_start (void);
void dma_output_stop (void);



    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _DMA_H_ */


