
#ifndef _SYSTEM_H_    /* Guard against multiple inclusion */
#define _SYSTEM_H_


/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif
    
/*******************************************
 * System libriares
 *******************************************/
#include <stdbool.h>
#include <string.h>
#include <sys/attribs.h>
#include <sys/kmem.h>
#include <xc.h>

/*******************************************
 * Project libriares
 *******************************************/
#include "../drivers/port/port.h"
#include "../drivers/clk/clk.h"
#include "../drivers/tmr/tmr.h"
#include "../drivers/dma/dma.h"
#include "../drivers/i2s/i2s.h"
#include "../drivers/usb/usb_LL.h"
#include "../drivers/usb/usb_PL.h"
#include "../app/dsp.h"

    
typedef enum {
    eSYSCLK_SPEED_LOW,
    eSYSCLK_SPEED_MID,
    eSYSCLK_SPEED_HIGH
}eSYSCLK_SPEED;
    
typedef union {
    uint32_t dw;
    struct {
        uint16_t w0;
        uint16_t w1;
    }word;
    struct {
        uint8_t b0;
        uint8_t b1;
        uint8_t b2;
        uint8_t b3;
    }byte;
}tDWORD;


typedef union {
    uint32_t events;
    struct {
        int16_t snum;
        uint16_t tasks;
    }w;
}tSYS_EVENTS;
    

// *****************************************************************************
// ************* User defines **************************************************
// *****************************************************************************
/* Define I2S masterclock */
// #define I2S_MCLK_512Fs
#define I2S_MCLK_1024Fs

/* Define output frame format */
//#define OUT_FRM_PCM32     // 32bit PCM frame
#define OUT_FRM_PCM16     // 16bit PCM frame
//#define OUT_FRM_DSD64     // DSD x64 frame

/* Enable system host volume control
 * When chainge - remoove USB device from system complitly!!! */
#define SYS_HOST_VOLUME_ENA
// Set constant input attenuation value (ignored if "SYS_HOST_VOLUME_ENA" !))
#define ATT_VALUE                       1 // 0.891 -1db

/* Define max output oversampling ratio */
//#define OUT_OVS_x8
#define OUT_OVS_x16

// ------- PCM frame type config -----------------------------------------------
// Set offset binary data format: 1 - enable, 0 - disable
#define OFFSET_BINARY                   0
// Set round data resolution
#define ROUND_DATA_WIDTH_bits           10
// Set output data lenght
#define OUTPUT_DATA_WIDTH_bits          16
// Set LFSR dither noise seed (zero value turn dithering off)
#define DITHERING_SEED                  1
// Enable noise shaping
#define NOISE_SHAPING_ENA
// Set output DC offset in 32bit domain
#define DC_OFFSET_LSB                   0
// *****************************************************************************
// *****************************************************************************
// *****************************************************************************

#ifdef OUT_FRM_PCM16
    #ifdef OUT_OVS_x8
        #define OUTPUT_BUFFER_bSIZE             8192u
    #endif
    #ifdef OUT_OVS_x16
        #define OUTPUT_BUFFER_bSIZE             16384u
    #endif
#endif

#ifdef OUT_FRM_PCM32
    #ifdef OUT_OVS_x8
        #define OUTPUT_BUFFER_bSIZE             16384u
    #endif
    #ifdef OUT_OVS_x16
        #define OUTPUT_BUFFER_bSIZE             32768u
    #endif
#endif

#ifdef OUT_FRM_DSD64
    #define OUTPUT_BUFFER_bSIZE                 4096u
#endif




#define GO_TO_IDLE()                    asm volatile ( "wait" )
    
// Define primary clock frequency
#define PRIMARY_CRYSTAL_FREQUENCY_Hz    12000000u
// Define secondary clock frequency
#define SECONDARY_CRYSTAL_FREQUENCY_Hz  0u
    
    
// System task bits list
#define SYS_TASK_USB_CONNECT            (0x01 << 0)
#define SYS_TASK_USB_EP0_ISR            (0x01 << 1)
#define SYS_TASK_USB_STREAM_OUT_INIT    (0x01 << 2)


// System tasks control macroses
#define _System_Task_Set(bit)           systemTasks.w.tasks |= (uint16_t)bit
#define _System_Task_Clr(bit)           systemTasks.w.tasks &= ~((uint16_t)bit)
#define _System_Task_Check(bit)         (systemTasks.w.tasks & ((uint16_t)bit))

#define _System_Num_Set(num)            systemTasks.w.snum = num
#define _System_Num_Inc(num)            systemTasks.w.snum += num
#define _System_Num_Dec(num)            systemTasks.w.snum -= num
#define _System_Num_Check()             systemTasks.w.snum

#define _System_Events_Check()          systemTasks.events




extern volatile tSYS_EVENTS systemTasks;
extern volatile int sysFreqHz;

    
/* System Func */
void sys_init (int sysfreq);



    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _SYSTEM_H_ */

/* *****************************************************************************
 End of File
 */
