#ifndef _DSP_H_    /* Guard against multiple inclusion */
#define _DSP_H_


/* ************************************************************************** */
/* ************************************************************************** */
/* Section: Included Files                                                    */
/* ************************************************************************** */
/* ************************************************************************** */

/* This section lists the other files that are included in this file.
 */

/* TODO:  Include other files here if needed. */


/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

#define DSP_ATT_SECTOR_SIZE         512
#define DSP_ATT_SECTOR_bSIZE        (DSP_ATT_SECTOR_SIZE*4)

#define DSP_FIR1_FIFO_SIZE          1024
#define DSP_FIR1_CELL_SIZE          256
#define DSP_FIR1_CELL_bSIZE         (DSP_FIR1_CELL_SIZE*4)
#define DSP_FIR1_SECTOR_SIZE        (DSP_FIR1_FIFO_SIZE + DSP_FIR1_CELL_SIZE)

#define DSP_FIR2_FIFO_SIZE          256
#define DSP_FIR2_CELL_SIZE          64
#define DSP_FIR2_CELL_bSIZE         (DSP_FIR2_CELL_SIZE*4)
#define DSP_FIR2_SECTOR_SIZE        (DSP_FIR2_FIFO_SIZE + DSP_FIR2_CELL_SIZE)

#define DSP_FIR3_FIFO_SIZE          256
#define DSP_FIR3_CELL_SIZE          64
#define DSP_FIR3_CELL_bSIZE         (DSP_FIR3_CELL_SIZE*4)
#define DSP_FIR3_SECTOR_SIZE        (DSP_FIR3_FIFO_SIZE + DSP_FIR3_CELL_SIZE)

#define DSP_FIR4_FIFO_SIZE          256
#define DSP_FIR4_CELL_SIZE          64
#define DSP_FIR4_CELL_bSIZE         (DSP_FIR4_CELL_SIZE*4)
#define DSP_FIR4_SECTOR_SIZE        (DSP_FIR4_FIFO_SIZE + DSP_FIR4_CELL_SIZE)

#define DSP_BUFFER_SIZE             (DSP_ATT_SECTOR_SIZE + DSP_FIR1_SECTOR_SIZE + DSP_FIR2_SECTOR_SIZE + DSP_FIR3_SECTOR_SIZE + DSP_FIR4_SECTOR_SIZE)
#define DSP_BUFFER_bSIZE            (DSP_BUFFER_SIZE*4)

#define DSP_ATT_SECTOR_OFF          0
#define DSP_FIR1_SECTOR_OFF         (DSP_ATT_SECTOR_OFF + DSP_ATT_SECTOR_SIZE)
#define DSP_FIR2_SECTOR_OFF         (DSP_FIR1_SECTOR_OFF + DSP_FIR1_SECTOR_SIZE)
#define DSP_FIR3_SECTOR_OFF         (DSP_FIR2_SECTOR_OFF + DSP_FIR2_SECTOR_SIZE)
#define DSP_FIR4_SECTOR_OFF         (DSP_FIR3_SECTOR_OFF + DSP_FIR3_SECTOR_SIZE)


#define _DSP_SampleNumInc(num)      dspSampleNum += num
#define _DSP_SampleNumGet()         dspSampleNum
#define DSP_OUTPUT_TRANSFET_PTR     (dspOutPtr << 2)

    
typedef struct {
    uint32_t adr;   // data buffer pointer
    int len;        // data buffer length
    int ptr;        // current data pointer
    int rem;        // remained data if no more free space if buffer
    int dmaen;      // enable DMA processing to copy taile to head
}tDSP_USB_FIFO_CTRL;

typedef struct {
    uint32_t adr;   // data buffer pointer
    int len;        // data buffer length
    int min;        // current data pointer
    int max;        // remained data if no more free space if buffer
}tDSP_USB_OUT_FIFO_CTRL;

typedef struct {
    uint32_t adr;   // data buffer pointer
    int len;   // data buffer length
    int min;   // minimal FIFO buffer fill
    int max;   // maximum FIFO buffer fill
}tDSP_OUT_CTRL;





uint32_t dsp_AttAdr_get(void);
void dsp_init (void);
void dsp_volume_set (uint16_t volume);
void dsp_restart (eUSB_SAMPLING_FREQ sreq);
void dsp_stop (void);
void dsp_proc (void);

extern volatile int dspOutPtr;



    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _DSP_H_ */