/*
    *MIPS32 inpstructions assembler code
*/
    
    
/* Input data structure

static struct {
    int volumeL;	// volume value: min - 0, max - 0x40000000
    int volumeR;	// volume value: min - 0, max - 0x40000000
    int lfsr;		// LFSR random generate register
    int off;		// DC offset in 32-bit LSBs
}tVolCtrl;
*/
    
    
/* Global functions declarations */
.global att32
.global volume32
    
    
    
    
    
    
    
/*
    att - attenuate one dual channel sample
     
    external declaration:     extern void att32(void *pSrc, void *pDst, void *pVol);

    input:
    pSrc - int source data pointer ($a0)
    pVol - control structure pointer ($a2)

    output:
    pDst - int result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
*/
att32:    
    // load volume value
    LW $t0, 0($a2)
    // load DC offset value
    LW $t1, 3($a2)
    // load unity gain value
    LI $t2, 0x40000000
    
    // load input sample Left
    LW $v0, 0($a0)
    // multiply data to volume coef
    MULT $ac0, $v0, $t0
    // Summ DC offset
    MADD $ac0, $t1, $t2
    
    // load input sample Right
    LW $v1, 4($a0)
    // multiply data to volume coef
    MULT $ac1, $v1, $t0
    // Summ DC offset
    MADD $ac1, $t1, $t2
    
    // Restore gain & round with saturation Left
    EXTR_RS.W $v0, $ac0, 30
    // save result Left
    SW $v0, 0($a1)
    
    // Restore gain & round with saturation Right
    EXTR_RS.W $v1, $ac1, 30
    // save result Right
    SW $v1, 4($a1)

    // restore address pointer
    J $ra

    
    
    
    
    
    
    
    

    
    
    
/*
    volume32 - volume control one sample dual channel with dithering round
     
    external declaration:     extern void volume32(void *pSrc, void *pDst, void *pVol);

    input:
    pSrc - int source data pointer ($a0)
    pVol - control structure pointer ($a2)

    output:
    pDst - int result destination data pointer ($a1)

    Source data array must contain dual channel int32 data samples.
*/
volume32:    
    // load volume Left
    LW $t0, 0($a2)
    // load volume Right
    LW $t1, 4($a2)
    // load LFSR value
    LW $t2, 8($a2)
    // load offset
    LW $t3, 12($a2)
    // load one
    LI $t4, 1
    // load unity gain value
    LI $t5, 0x40000000

    // LFSR one shift processing with 0x94400000 polynome
    AND $v1, $t2, 1
    MUL $v1, $v1, 0x94400000
    SRL $t2, $t2, 1
    XOR $t2, $t2, $v1
    // save LFSR value
    SW $t2, 8($a2)
    // restore gain
    SRA $t2, $t2, 1
    
    // load input sample Left
    LW $v0, 0($a0)
    // multiply data to volume coef
    MULT $ac0, $v0, $t0
    // sum dithering noise
    MADD $ac0, $t4, $t2
    // Summ DC offset
    MADD $ac0, $t5, $t3
    
    // load input sample Right
    LW $v1, 4($a0)
    // multiply data to volume coef
    MULT $ac1, $v1, $t1
    // sum dithering noise
    MADD $ac1, $t4, $t2
    // Summ DC offset
    MADD $ac1, $t5, $t3
    
    // Restore gain & round with saturation Left
    EXTR_RS.W $v0, $ac0, 30
    // save result Left
    SW $v0, 0($a1)
    
    // Restore gain & round with saturation Right
    EXTR_RS.W $v1, $ac1, 30
    // save result Right
    SW $v1, 4($a1)

    // restore address pointer
    J $ra
