
`include "DEFINES.v"

module SAI_INPUT
#( parameter
	W = 27,						// W = 27 - data bus width
	FORMAT = `IFORMAT_I2S		// 0 - I2S, 1 - LJ, 2 - RJ24, 3 - RJ16
) 
(
// Mute control, active high
input iMUTE,
// Serial data input
input iLRC, iSCK, iDAT,
// Parallel data output
output signed[W-1:0] QL, QR
);

reg rLRC, rDAT;
reg[4:0] rCntL, rCntH;
reg signed[W-1:0] rSHL, rSHH, rDL, rDR;

wire wDAT = (FORMAT == `IFORMAT_I2S) ? iDAT : rDAT;

assign QL = rDL;
assign QR = rDR;

always@ (posedge iSCK or posedge rLRC) begin
	if (rLRC) rCntL <= 0;
	else if (rCntL < W) rCntL <= rCntL + 1;
end

always@ (posedge iSCK or negedge rLRC) begin
	if (!rLRC) rCntH <= 0;
	else if (rCntH < W) rCntH <= rCntH + 1;
end

always@ (posedge iSCK) begin
	rLRC <= (FORMAT == `IFORMAT_I2S) ? !iLRC : iLRC;
	rDAT <= iDAT;
	
	if (FORMAT == `IFORMAT_RJ16) begin
		if (!rLRC) rSHL[W-1:W-16] <= (rSHL[W-1:W-16] << 1) | wDAT;
		if (rLRC) rSHH[W-1:W-16] <= (rSHH[W-1:W-16] << 1) | wDAT;
	end
	else if (FORMAT == `IFORMAT_RJ24) begin
		if (!rLRC) rSHL[W-1:W-24] <= (rSHL[W-1:W-24] << 1) | wDAT;
		if (rLRC) rSHH[W-1:W-24] <= (rSHH[W-1:W-24] << 1) | wDAT;
	end 
	else begin
		if (!rLRC) begin
				 if (rCntL < 16) rSHL[W-1:W-16] <= (rSHL[W-1:W-16] << 1) | wDAT;
			else if (rCntL < 24) rSHL[W-17:W-24] <= (rSHL[W-17:W-24] << 1) | wDAT;
			else if (rCntL < W) rSHL[W-25:0] <= (rSHL[W-25:0] << 1) | wDAT;
		end
		
		if (rLRC) begin
				 if (rCntH < 16) rSHH[W-1:W-16] <= (rSHH[W-1:W-16] << 1) | wDAT;
			else if (rCntH < 24) rSHH[W-17:W-24] <= (rSHH[W-17:W-24] << 1) | wDAT;
			else if (rCntH < W) rSHH[W-25:0] <= (rSHH[W-25:0] << 1) | wDAT;
		end
	end
end

// Add overflow msb (divide input data by 2)
always@ (posedge rLRC) begin
	rDL <= (iMUTE)? 0 : (rSHH >>> 1);
	rDR <= (iMUTE)? 0 : (rSHL >>> 1);
end





endmodule

















