
`define LOGIC_LCMXO2	// Lattice LCMXO2 Logic Optimisation

// COEF TYPES
`define ST_TYPE_LIN_PHASE		(2'h0)
`define ST_TYPE_HALFBAND		(2'h1)
`define ST_TYPE_MIN_PHASE		(2'h2)

// Stages numbers
`define STIN_NUM				1	// input data
`define ST1_NUM					2	// 1 stage of x2 interpolator
`define ST2_NUM					3	// 2 stage of x2 interpolator
`define ST3_NUM					4	// 3 stage of x2 interpolator
`define ST4_NUM					5	// 4 stage of x2 interpolator
`define ST5_NUM					6	// 5 stage of x2 interpolator
`define STOUT_NUM				7	// output data buffer

// Addresses fields widths in bits
`define ST1_ADRW_BITS			8
`define ST2_ADRW_BITS			6
`define ST5_ADRW_BITS			6
`define OBUF_ADRW_BITS			6
`define ST3_ADRW_BITS			5
`define ST4_ADRW_BITS			5


/******************* DF2 control defines ************************/
// Input data format
`define IFORMAT_I2S				2'h0
`define IFORMAT_LJ				2'h1
`define IFORMAT_RJ24			2'h2
`define IFORMAT_RJ16			2'h3

// Master Clock set defines
`define MCLK_SEL_x1024			1'b0
`define MCLK_SEL_x768			1'b1

// Low Power Mode set defines
`define DF_MODE_NORM			2'h0
`define DF_MODE_SHARP			2'h1
`define DF_MODE_SHORT			2'h2
`define DF_MODE_CUST			2'h3

// Input Oversampling ratio defines
`define INPUT_OVS_x1			3'h0
`define INPUT_OVS_x2			3'h1
`define INPUT_OVS_x4			3'h2
`define INPUT_OVS_x8			3'h3
`define INPUT_OVS_x16			3'h4
`define INPUT_OVS_ERR			3'h7

// DF2 additional upsampler mode
`define DF2_UPSAMPLE_NONE		0
`define DF2_UPSAMPLE_x2			1
`define DF2_UPSAMPLE_x4			2
`define DF2_UPSAMPLE_x8			3
`define DF2_UPSAMPLE_x16		4
`define DF2_UPSAMPLE_x32		5

// Output Oversampling ratio defines
`define OVS_MAX_x1				3'h0
`define OVS_MAX_x2				3'h1
`define OVS_MAX_x4				3'h2
`define OVS_MAX_x8				3'h3
`define OVS_MAX_x16				3'h4
`define OVS_MAX_x32				3'h5
/****************************************************************/

/****************************************************************/
/******************** FIFO RAM mapping **************************/
/****************************************************************/
// FIFO RAM addresses mapping. Total size is 512 words
`define ST1_ADR_MASK			(9'b000000000)	// 256 words sector address
`define ST2_ADR_MASK			(9'b100000000)	// 64 words sector address
`define ST5_ADR_MASK			(9'b101000000)	// 64 words sector address
`define OBUF_ADR_MASK			(9'b110000000)	// 64 words sector address
`define ST3_ADR_MASK			(9'b111000000)	// 32 words sector address
`define ST4_ADR_MASK			(9'b111100000)	// 32 words sector address
/****************************************************************/

/****************************************************************/
/******************** FIR Types *********************************/
/****************************************************************/
`define TYPE_ST1_FIR			`ST_TYPE_LIN_PHASE
`define TYPE_ST1_FIRS			`ST_TYPE_LIN_PHASE
`define TYPE_ST1_MPH			`ST_TYPE_MIN_PHASE
`define TYPE_ST1x2_MPH			`ST_TYPE_MIN_PHASE
`define TYPE_ST1x4_MPH			`ST_TYPE_MIN_PHASE
`define TYPE_ST1_HB				`ST_TYPE_HALFBAND
`define TYPE_ST1_HBS			`ST_TYPE_HALFBAND
`define TYPE_ST2_HB				`ST_TYPE_HALFBAND
`define TYPE_ST3_HB				`ST_TYPE_HALFBAND
`define TYPE_ST4_HB				`ST_TYPE_HALFBAND
`define TYPE_ST5_HB				`ST_TYPE_HALFBAND

/****************************************************************/
/************ FIR Length, defines as: taps num - 1 **************/
/****************************************************************/
`define LEN_ST1_FIR				(156-1)
`define LEN_ST1_FIRS			(27-1)
`define LEN_ST1_MPH				(173-1)
`define LEN_ST1x2_MPH			(33-1)
`define LEN_ST1x4_MPH			(19-1)
`define LEN_ST1_HB				(98-1)
`define LEN_ST1_HBS				(42-1)
`define LEN_ST2_HB				(16-1)
`define LEN_ST3_HB				(8-1)
`define LEN_ST4_HB				(6-1)
`define LEN_ST5_HB				(4-1)
/****************************************************************/

/****************************************************************/
/**************** FIR 12bit Data Length *************************/
/****** Defined as number of words in COEF RAM ******************/
/****************************************************************/
`define DLEN_ST1_FIR			320
`define DLEN_ST1_FIRS			64
`define DLEN_ST1_MPH			352
`define DLEN_ST1x2_MPH			80
`define DLEN_ST1x4_MPH			48
`define DLEN_ST1_HB				208
`define DLEN_ST1_HBS			96
`define DLEN_ST2_HB				32
`define DLEN_ST3_HB				16
`define DLEN_ST4_HB				16
`define DLEN_ST5_HB				16
/****************************************************************/

/****************************************************************/
/**************** Coefficients ROM mapping **********************/
/****************************************************************/
/********** Address must bu multiple by 4! **********************/
`define COEF_ADR_ST1_FIR		0
`define COEF_ADR_ST1_FIRS		(`COEF_ADR_ST1_FIR + `DLEN_ST1_FIR)
`define COEF_ADR_ST1_MPH		(`COEF_ADR_ST1_FIRS + `DLEN_ST1_FIRS)
`define COEF_ADR_ST1x2_MPH		(`COEF_ADR_ST1_MPH + `DLEN_ST1_MPH)
`define COEF_ADR_ST1x4_MPH		(`COEF_ADR_ST1x2_MPH + `DLEN_ST1x2_MPH)
`define COEF_ADR_ST1_HB			(`COEF_ADR_ST1x4_MPH + `DLEN_ST1x4_MPH)
`define COEF_ADR_ST1_HBS		(`COEF_ADR_ST1_HB + `DLEN_ST1_HB)
`define COEF_ADR_ST2_HB			(`COEF_ADR_ST1_HBS + `DLEN_ST1_HBS)
`define COEF_ADR_ST3_HB			(`COEF_ADR_ST2_HB + `DLEN_ST2_HB)
`define COEF_ADR_ST4_HB			(`COEF_ADR_ST3_HB + `DLEN_ST3_HB)
`define COEF_ADR_ST5_HB			(`COEF_ADR_ST4_HB + `DLEN_ST4_HB)
/************ Attenuator control mapping ************************/
/********** Address must bu multiple by 2! **********************/
`define COEF_ADR_ATT_0db		(`COEF_ADR_ST5_HB + `DLEN_ST5_HB)
`define COEF_ADR_ATT_1db		(`COEF_ADR_ATT_0db + 2)
`define COEF_ADR_ATT_2db		(`COEF_ADR_ATT_1db + 2)
`define COEF_ADR_ATT_CUST		(`COEF_ADR_ATT_2db + 2) // address for manual volume control
/****************************************************************/
/********** Address must bu multiple by 4! **********************/
/********** Custom FIR start address ****************************/
`define COEF_ADR_CUST			(`COEF_ADR_ATT_CUST + 2 + 8)
/****************************************************************/













