`include "DEFINES.v"

module CIC3
#( parameter
	W = 27, 	// Data width in bits
	OVS = 1 	// Oversampling Ratio = 2 ^ OVS
)
(
input CLK, CLRn,
input ISENA,	// Input Sampling Enable
input OSENA,	// Output Sampling Enable
input signed[W-1:0] D,
output signed[W-1:0] Q
);

// registers width
localparam RW = W + 2*OVS;

reg signed[RW-1:0] rCOMB0, rCOMB1, rCOMB2, rCOMBPP, rINTEG0, rINTEG1, rINTEG2;
reg signed[W-1:0] rD, rRND;

/****** Async Logic ************************/
wire signed[RW-1:0] wSUB0 = rD - rCOMB0;
wire signed[RW-1:0] wSUB1 = wSUB0 - rCOMB1;
wire signed[RW-1:0] wSUB2 = wSUB1 - rCOMB2;
	`ifdef LOGIC_LCMXO2
wire signed[RW-1:0] wSUM0 = ISENA * rCOMBPP + rINTEG0;
	`else
wire signed[RW-1:0] wSUM0 = (ISENA) ? (rCOMBPP + rINTEG0) : rINTEG0;
	`endif
wire signed[RW-1:0] wSUM1 = rINTEG0 + rINTEG1;
wire signed[RW-1:0] wSUM2 = rINTEG1 + rINTEG2;

wire wCLRn = CLRn & !(rINTEG2[RW-1] ^ rINTEG2[RW-2]);
/*******************************************/

/********** Output Assigments **************/
assign Q = (OVS) ? ((rINTEG2 + (1 << (2*OVS-1))) >>> 2*OVS) : D;
/*******************************************/

always@ (posedge CLK or negedge CLRn) begin
	if (!CLRn) begin
		rCOMB0 <= 0; rCOMB1 <= 0; rCOMB2 <= 0; rCOMBPP <= 0;
		rINTEG0 <= 0; rINTEG1 <= 0; rINTEG2 <= 0;
		rD <= 0; rRND <= 0;
	end
	else begin
		if (ISENA) begin
			rD <= D;
			rCOMB0 <= rD;
			rCOMB1 <= wSUB0;
			rCOMB2 <= wSUB1;
			rCOMBPP <= wSUB2;
		end
		
		if (OSENA) begin
			rINTEG0 <= wSUM0;
			rINTEG1 <= wSUM1;
			rINTEG2 <= wSUM2;
		end
	end
end

endmodule


module FIRx2 // x2 Linear Phase FIR Interpolator: 0.25 - 0.75 - 0.75 - 0.25
#( parameter 
	W = 27 	// Data width in bits
)
(
input CLK, CLRn,
input ISENA,	// Input Sampling Enable
input OSENA,	// Output Sampling Enable
input signed[W-1:0] D,
output signed[W-1:0] Q
);

reg signed[W-1:0] rD1, rD2, rQ;

/****** Async Logic ************************/
	`ifdef LOGIC_LCMXO2
wire signed[W-1:0] wD = ISENA * rD1 + !ISENA * rD2;
	`else
wire signed[W-1:0] wD = (ISENA) ? rD1 : rD2;
	`endif
wire signed[W-1:0] wS = (rD2 + rD1 + (wD << 1) + 2) >>> 2;
/*******************************************/

/********** Output Assigments **************/
assign Q = rQ;
/*******************************************/
always@ (posedge CLK or negedge CLRn) begin
	if (!CLRn) begin
		rD1 <= 0; rD2 <= 0; rQ <= 0;
	end
	else begin
		if (ISENA) begin
			rD1 <= D;
			rD2 <= rD1;
		end
			
		if (OSENA) rQ <= wS;
	end
end

endmodule




















