
`include "DEFINES.v"


module FIR_MAC
#( parameter DW = 27, CW = 12, AW = 36 )
(
/***** Global clock signals *****/
input iCLK, iCLRn, iENA,
// load multiplier data & start multiply
input iSTART_LOAD,
// sum additional sample to symmetric FIR
input iSUM_LOAD,
// mux signal to load input data
input iMUX,
// write stage num from ADR_GEN
input[2:0] iSTG,

// MAC data input from RAM
input signed[DW-1:0] iDRAM,
// MAC data from input module
input signed[DW-1:0] iDIN,
// MAC coef input from ROM
input [CW-1:0] iC,

/******** RAM control data ********/
// MAC data output
output signed[DW-1:0] oD,
// MAC write satge to ADR_GEN
output[2:0] oSTG
/**********************************/
);

reg rAccInit;
reg[4:0] rStart;
reg[2:0] rStg0, rStg1, rStgWr;
reg signed[DW+CW:0] rMult, rSumShift;
reg signed[AW-1:0] rAcc;
reg signed[DW:0] rDmux, rSumIn;
// Async Logic
wire signed[CW:0] wC = {iC[CW-1]*rStart[2], iC};
wire signed[DW:0] wDin = iDIN;
wire signed[DW:0] wDmux = (iMUX) ? (wDin << 1) : iDRAM;
wire signed[DW+CW:0] wSumShift = rSumShift >>> CW;
wire signed[AW-1:0] wAccSum = rSumShift >>> (DW+CW-AW-1);

/******** output assigments ********/
assign oD = rAcc >>> (AW-DW);
assign oSTG = rStgWr;
/***********************************/

always@ (posedge iCLK or negedge iCLRn) begin
	if (!iCLRn) begin
		rStart <= 0; rAccInit <= 0;
		rStg0 <= 0; rStg1 <= 0; rStgWr <= 0;
		rDmux <= 0; rSumIn <= 0;
		rMult <= 0; rSumShift <= 0; rAcc <= 0;
	end
	else if (iENA) begin
		// start sync signal shift
		rStart <= (rStart << 1) | iSTART_LOAD;
		
		// stage num delay to write result
		if (iSTART_LOAD | rStart[1]) rStg0 <= iSTG;
		if (rStart[1] | rStart[3]) rStg1 <= rStg0;
		rStgWr <= (rStart[3]) ? rStg1 : 0;
		rAccInit <= (rStgWr) ? 1 : 0;
		
		// Input data load and sum
		if (iSTART_LOAD) rDmux <= wDmux; // load data from FIFO RAM or from input
			
			`ifdef LOGIC_LCMXO2
		if (rStart[0]) rSumIn <= rDmux + iSUM_LOAD * wDmux; // sum data to linear phase FIR		
			`else
		if (rStart[0]) rSumIn <= (iSUM_LOAD) ? (rDmux + wDmux) : rDmux; // sum data to linear phase FIR
			`endif
		
		// Dual tact multiply processing
		rMult <= rSumIn * wC;
		
			`ifdef LOGIC_LCMXO2
		if (rStart[2] | rStart[3]) rSumShift <= rMult + rStart[3] * wSumShift;
			`else
		if (rStart[2]) rSumShift <= rMult;
		else if (rStart[3]) rSumShift <= rMult + wSumShift;
			`endif		
		
		// Accumulate processing
		if (rStart[4]) rAcc <= rAcc + wAccSum;	// Accumulate data
		else if (rAccInit) rAcc <= 1 << (AW-DW-1);	// Init with round value	
	end
end



endmodule













