/***************************************************************/
/******** DF2 alpfa 1.0  LCMXO2-2000HE FPGA Example ************/
/***************************************************************/

`include "SAI_INPUT.v"
`include "DF2_FIR_CORE.v"
`include "SAI_OUTPUT.v"

`define DF2_DATA_BUS_WIDTH_BITS			27
`define DF2_COEF_BUS_WIDTH_BITS			24
`define DF2_MAC_WIDTH_BITS				36


module DF2
(
/***** Global clock signals **************/
input iCLK,

// oscillator clock control
input iOSCSEL,			// OSC select input
output oOSC1EN, oOSC2EN,// Control outputs to enable selected OSC

/***** Oversampling & overflow indication ***********/
output[2:0] oINOVS,	// input sample rate indicate outputs: 0 - 44/48, 1 - 88/96, 2 - 176/192, 3 - 352/384, 4 - 705/768, 7 - error

/***** Serial data inputs ************/
input iLRC, iSCK, iDAT, iMUTE,
/***** Serial data outputs ***********/
output oDL, oDR, oBCK, oWCK, oDG,
output oMCKO			// Output masterclock to data source
);

/****************** Local Parameters ***************************/
localparam MCLKSEL = `MCLK_SEL_x1024;	// `MCLK_SEL_x1024  `MCLK_SEL_x768
localparam DFMODE = `DF_MODE_SHARP;	// `DF_MODE_NORM `DF_MODE_SHARP `DF_MODE_SHORT `DF_MODE_CUST
localparam OVSMAX = `OVS_MAX_x16;		// Output Maximum Oversampling ratio
localparam DLEN = 20;					// Output data resolution (in bits)
localparam ATT = 0;					// 0: 0db, 1: -1db, 2: -2db, 3: -3db/manual value


/****************** SAI_INPUT output wires *********************/
wire signed[`DF2_DATA_BUS_WIDTH_BITS-1:0] wSAI_IN_QL, wSAI_IN_QR;
/****************** DF2_FIR_CORE output wires ******************/
wire signed[23:0] wFIR_CORE_QL, wFIR_CORE_QR;


/***************************************************************/
/******** Optional Custom Control Example **********************/
/***************************************************************/
reg rCLK;
always@ (posedge iCLK) begin
	rCLK <= !rCLK;	// Divide iCLK frequency by 2
end

/***************************************************************/
/***************************************************************/
/***************************************************************/

/*********** Output Assigments **********************/
assign oMCKO = rCLK;		// F oMCK = F iCLK / 2
assign oOSC1EN = iOSCSEL;
assign oOSC2EN = !iOSCSEL;
/****************************************************/


SAI_INPUT
#(
	.W( `DF2_DATA_BUS_WIDTH_BITS ),
	.FORMAT( `IFORMAT_I2S )				// `IFORMAT_I2S  `IFORMAT_LJ  `IFORMAT_RJ24  `IFORMAT_RJ16
) _SAI_INPUT
(
	// Mute control, active high
	.iMUTE( iMUTE ),
	// Serial data input
	.iLRC( iLRC ), .iSCK( iSCK ), .iDAT( iDAT ),
	// Parallel data output
	.QL( wSAI_IN_QL ), .QR( wSAI_IN_QR )
);


DF2_FIR_CORE 
#(
	.DW( `DF2_DATA_BUS_WIDTH_BITS ),
	.CW( `DF2_COEF_BUS_WIDTH_BITS ),
	.AW( `DF2_MAC_WIDTH_BITS ),
	.MCLKSEL( MCLKSEL ),				// 0 - 1024Fs, 1 - 768Fs
	.UPSAMPLE( `DF2_UPSAMPLE_NONE ),	// Additional UpSampling stage: `DF2_UPSAMPLE_x2 ... `DF2_UPSAMPLE_x32
	.LENMIN( DLEN ),					// Minimum output data resolution (in bits)
	.NSHOR( 1 )						// Noise Shaper Order: 1..3, 0 - Shaper Off
) _DF2_FIR_CORE
(
	//***** Global clock signals ********
	.iCLK( iCLK ), .iCLRn( 1'b1 ),
	// LRC input for automatic oversampling ratio selection
	.iLRC( iLRC ),
	
	//***** SPI control interface *******
	.iSPI_SCK( 1'b0 ), .iSPI_DAT( 1'b0 ), .iSPI_CS( 1'b1 ),

	//***** DF control inputs ***********
	// attenuate control
	.iATT( ATT ),						// 0: 0db, 1: -1db, 2: -2db, 3: -3db/manual value
	// filter mode
	.iDF_MODE( DFMODE ),				// 0: normal, 1: sharp, 2: short, 3: slow/custom
	// max oversampling ratio
	.iOVS_MAX( OVSMAX ),				// 0: x1 (bypass), 1 - x2, 2 - x4, 3 - x8, 4 - x16, 5 - x32
	.iODW( DLEN ),						// output data width in bits
	.iSHPEN( 1'b1 ), .iDITHEN( 1'b1 ),	// Debug outputs to turn off shaping and dither

	//***** Input Data Bus **************
	.DL( wSAI_IN_QL ), .DR( wSAI_IN_QR ),
	//***** Output Data Bus *************
	.QL( wFIR_CORE_QL ), .QR( wFIR_CORE_QR ),

	.oINOVS( oINOVS ),					// Input sample rate indication 7 - error, 0 - 44/48, 1 - 88/96, 2 - 176/192, 3 - 352/384, 4 - 705/768
	.oOVFL(  ), .oOVFR(  )				// Input data overflow indication outputs
);


// Simple Serial Audio Interface Output
SSAI_OUTPUT
#(
	.MCLKSEL( MCLKSEL ),// 0 - 1024Fs, 1 - 768Fs
	
	// ********** Data Control **********************
	.DLEN( DLEN ), 	// data width in bits
	.OB( 0 ),			// 1 - offset binary, 0 - 2's complement
	.DATINV( 0 ),		// Output data invertion
	// **********************************************
	
	// ********** Bit Clock Control *****************	
	.BCKDIV( 1 ), 		// output data rate BCK = iCLK/(2^CKDIV)
	.BCKINV( 0 ),		// 1 - invert BCK clock: 0 = update data on falling BCK; 1 = update data on rising BCK
	// **********************************************
	
	// ********** Word Clock Control ****************
	.WCKW( 32 ),		// WCK strobe width in iCLK periods
	.WCKINV( 0 ),		// 1 - invert WCK strobe: 0 = update DAC on falling WCK; 1 = update DAC on rising WCK
	// **********************************************
	
	// ********** Deglitcher Control ****************
	.DGHW( 20 ),		// 1..31 - deglitcher HOLD width
	.DGINV( 0 )		// 1 - invet DG strobe: 0 = 1-hold, 0-sample; 1 = 0-hold, 1-sample
	// **********************************************	

) _SAI_OUTPUT
(
	// input global signals
	.iCLK( iCLK ), .iCLRn( 1'b1 ),
	// input control signals
	.iOVS_MAX( OVSMAX ),		// 0: x1 (bypass), 1 - x2, 2 - x4, 3 - x8, 4 - x16, 5 - x32
	.iDGEN( 1'b1 ),			// 0 - turn deglitching signal to always sample state
	// input data
	.iDL( wFIR_CORE_QL ), .iDR( wFIR_CORE_QR ),
	// output data (LAT - not used)
	.oDL( oDL ), .oDR( oDR ), .oBCK( oBCK ), .oWCK( oWCK ), .oDG( oDG )
); // */





endmodule




















