
#include "../../app/system.h"
#include "dma.h"


// One sample 8-ch DMA buffer to channels separation
static uint32_t dmabuf[8] __attribute__((coherent));
// data source to fifo cleare
static uint32_t dwclr __attribute__((coherent));

/*
 * dma_init()
 */
void dma_init (void)
{    
    DMACONbits.ON = 1;                          // Enable DMA controller
    
    /**************************************************************************/
    /* Channel 0 config - to copy data from EP1 FIFO to dmabuf                */
    /**************************************************************************/    
    DCH0CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete
    // Only separate fields support!!!!
    DCH0ECONbits.SIRQEN = 1;                    // Enable transfer IRQ

    /**************************************************************************/
    /* Channel 1 config - to copy data from dmabuf buffer to I2S1 module      */
    /**************************************************************************/
    DCH1DSA = KVA_TO_PA( &SPI1BUF );            // Destination address (I2S FIFO buffer)
    DCH1DSIZ = 4;                               // Destination size
    DCH1SSA = KVA_TO_PA( &dmabuf[0] );          // Source data start address  (SDO1 to pin 45)
    DCH1SSIZ = 8;                               // Source size
    DCH1CSIZ = 8;                               // Cell data size: channel audio data size (4 bytes)
    DCH1CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete
    DCH1CONbits.CHPRI = 0x1;                    // Set channel priority higher than ch0
    // Only separate fields support!!!!
    DCH1ECONbits.CHSIRQ = _SPI1_TX_VECTOR;      // Channel Transfer Start IRQ
    DCH1ECONbits.SIRQEN = 1;                    // Enable transfer IRQ
    
    /**************************************************************************/
    /* Channel 2 config - to copy data from dmabuf buffer to I2S2 module      */
    /**************************************************************************/
    DCH2DSA = KVA_TO_PA( &SPI2BUF );            // Destination address (I2S FIFO buffer)
    DCH2DSIZ = 4;                               // Destination size
    DCH2SSA = KVA_TO_PA( &dmabuf[6] );          // Source data start address (SDO4 to pin 46)
    DCH2SSIZ = 8;                               // Source size
    DCH2CSIZ = 8;                               // Cell data size: channel audio data size (4 bytes)
    DCH2CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete
    DCH2CONbits.CHPRI = 0x1;                    // Set channel priority higher than ch0
    // Only separate fields support!!!!
    DCH2ECONbits.CHSIRQ = _SPI2_TX_VECTOR;      // Channel Transfer Start IRQ
    DCH2ECONbits.SIRQEN = 1;                    // Enable transfer IRQ

    /**************************************************************************/
    /* Channel 3 config - to copy data from dmabuf buffer to I2S3 module      */
    /**************************************************************************/
    DCH3DSA = KVA_TO_PA( &SPI3BUF );            // Destination address (I2S FIFO buffer)
    DCH3DSIZ = 4;                               // Destination size
    DCH3SSA = KVA_TO_PA( &dmabuf[4] );          // Source data start address (SDO3 to pin 47)
    DCH3SSIZ = 8;                               // Source size
    DCH3CSIZ = 8;                               // Cell data size: channel audio data size (4 bytes)
    DCH3CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete
    DCH3CONbits.CHPRI = 0x1;                    // Set channel priority higher than ch0
    // Only separate fields support!!!!
    DCH3ECONbits.CHSIRQ = _SPI3_TX_VECTOR;      // Channel Transfer Start IRQ
    DCH3ECONbits.SIRQEN = 1;                    // Enable transfer IRQ
    
    /**************************************************************************/
    /* Channel 4 config - to copy data from EP1 FIFO to dmabuf                */
    /**************************************************************************/
    DCH4DSA = KVA_TO_PA( &SPI4BUF );            // Destination address (I2S FIFO buffer)
    DCH4DSIZ = 4;                               // Destination size
    DCH4SSA = KVA_TO_PA( &dmabuf[2] );          // Source data start address (SDO2 to pin 51)
    DCH4SSIZ = 8;                               // Source size
    DCH4CSIZ = 8;                               // Cell data size: channel audio data size (4 bytes)
    DCH4CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete
    DCH4CONbits.CHPRI = 0x1;                    // Set channel priority higher than ch0
    // Only separate fields support!!!!
    DCH4ECONbits.CHSIRQ = _SPI4_TX_VECTOR;      // Channel Transfer Start IRQ
    DCH4ECONbits.SIRQEN = 1;                    // Enable transfer IRQ


    /**************************************************************************/
    /* Channel 5 config - to cleare fifo buf                                  */
    /**************************************************************************/
    dwclr = 0;
    DCH5SSA = KVA_TO_PA( &dwclr );              // Source data start address
    DCH5SSIZ = 4;                               // Source size
    DCH5CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete 
    DCH5ECONbits.SIRQEN = 1;                    // Enable transfer IRQ
}

/*
 * dma_output_2ch_start()
 */
void dma_output_2ch_start (const uint16_t size)
{
    // Config channel to stereo output
    DCH0SSIZ = size;                        // Source size
    DCH0DSA = KVA_TO_PA( &SPI1BUF );        // Destination address
    DCH0DSIZ = 4;                           // Destination size ( buf data size 4 bytes * 8 channels = 32 bytes )
    DCH0CSIZ = 8;                           // Cell data size: channel audio data size (4 bytes)
    DCH0ECONbits.CHSIRQ = _SPI1_TX_VECTOR;  // Channel Transfer Start IRQ    
        
    // Config fifo cleare
    DCH5DSIZ = size;                        // Destination size ( buf data size 4 bytes * 8 channels = 32 bytes )
    DCH5CSIZ = 8;                           // Cell data size: channel audio data size (4 bytes)
    DCH5ECONbits.CHSIRQ = _SPI1_TX_VECTOR;  // Channel Transfer Start IRQ
    
    // Enable DMA channel
    DCH0CONbits.CHEN = 1;
    DCH5CONbits.CHEN = 1;
}

/*
 * dma_output_8ch_start()
 */
void dma_output_8ch_start (const uint16_t size)
{
    // Config channel to copy 8-ch sample
    DCH0SSIZ = size;                        // Source size
    DCH0DSA = KVA_TO_PA( dmabuf );          // Destination address
    DCH0DSIZ = 32;                          // Destination size ( buf data size 4 bytes * 8 channels = 32 bytes )
    DCH0CSIZ = 32;                          // Cell data size: channel audio data size (4 bytes)
    DCH0ECONbits.CHSIRQ = _SPI4_TX_VECTOR;  // Channel Transfer Start IRQ    
    
    // Config fifo cleare
    DCH5DSIZ = size;                        // Destination size ( buf data size 4 bytes * 8 channels = 32 bytes )
    DCH5CSIZ = 32;                          // Cell data size: channel audio data size (4 bytes)
    DCH5ECONbits.CHSIRQ = _SPI4_TX_VECTOR;  // Channel Transfer Start IRQ   

    // Enable DMA chanels
    DCH0CONbits.CHEN = 1;
    DCH1CONbits.CHEN = 1;
    DCH2CONbits.CHEN = 1;
    DCH3CONbits.CHEN = 1;
    DCH4CONbits.CHEN = 1;
    DCH5CONbits.CHEN = 1;
}

/*
 * dma_output_stop()
 */
void dma_output_stop (void)
{
    if (DCH0CONbits.CHEN)
        DCH0ECONbits.CABORT = 1;

    if (DCH1CONbits.CHEN)
        DCH1ECONbits.CABORT = 1;

    if (DCH2CONbits.CHEN)
        DCH2ECONbits.CABORT = 1;

    if (DCH3CONbits.CHEN)
        DCH3ECONbits.CABORT = 1;
    
    if (DCH4CONbits.CHEN)
        DCH4ECONbits.CABORT = 1;

    if (DCH5CONbits.CHEN)
        DCH5ECONbits.CABORT = 1;

    while (DCH0CONbits.CHBUSY);
    while (DCH1CONbits.CHBUSY);
    while (DCH2CONbits.CHBUSY);
    while (DCH3CONbits.CHBUSY);
    while (DCH4CONbits.CHBUSY);
    while (DCH5CONbits.CHBUSY);
}



