
#include "../../app/system.h"
#include "port.h"



/*
 port_init() - mcu port power up initialisation
 */
void port_init (void)
{ 
    OSCSEL_SET_LOW();                      // set oscsel to 48k domain

     /*Configure ports direction. 1 - input, 0 - output*/
    TRISDCLR = _BIT(0) | _BIT(1) | _BIT(3) | _BIT(9) | _BIT(10) | _BIT(11) // I2S output pins: sdo4,sck1,sdo2,ss1,sck4,sdo3
             | _BIT(4)                                                     // 44-48 pin 
            ;
    TRISBCLR = _BIT(3) | _BIT(14);                      // Uart1 TX output, sck3
                
    TRISCCLR = _BIT(13);                                // sdo1 
    
    TRISGCLR = _BIT(6);                                 // sck2
                                         
   // ANSELCCLR = _BIT(13);
   //ANSELDCLR = _BIT(0) | _BIT(3) | _BIT(9)  | _BIT(11);// Switch Off Analog Function for I2S outputs (4 data +ss1)
            
    /*Configure ports Pull Up. 1 - pull enable*/
    CNPUFSET = _BIT(3); // USBID input Pull-Up
           
    /*Configure ports Pull Down. 1 - pull enable*/
    CNPDBSET = _BIT(2) | _BIT(4) | _BIT(5) | _BIT(6) | _BIT(7) | _BIT(8) | _BIT(9) | _BIT(10) | _BIT(11) | _BIT(12) | _BIT(13) | _BIT(15);
    CNPDCSET = _BIT(15);
    CNPDDSET = _BIT(2) | _BIT(5);
    CNPDESET = _BIT(0) | _BIT(1) | _BIT(2) | _BIT(3) | _BIT(4) | _BIT(5) | _BIT(6) | _BIT(7);
    CNPDFSET = _BIT(0) | _BIT(1) | _BIT(3) | _BIT(4) | _BIT(5);
    CNPDGSET = _BIT(6) | _BIT(7) | _BIT(8) | _BIT(9);
    
    /************ Remappable pins *******************/    
    REFCLKI1Rbits.REFCLKI1R = 0x07; // RPC14  REFCLKI1 input
    
    // I2S1 remappable outputs
    RPD11R = 0x5;    // 0101 = SDO1 pin 45
    RPD9R = 0x5;     // 0101 = SS1out pin 43
    
    // I2S2 remappable outputs
    RPD3R = 0x6;     // 0110 = SDO2 pin 51 
    
    // I2S3 remappable outputs
    RPC13R = 0x7;    // 0111 = SDO3 pin 47
    
    // I2S4 remappable outputs
    RPD0R = 0x8;     // 1000 = SDO4 pin 46   
    
    // UART1 remappable output
    RPB3R = 0x1;     // 0001 = U1TX pin13
}


