module ram_WxD
#( parameter W = 64 )
(
// global clock input
input clk, clrn,
// control ipnut
input[8:0] rdadr, wradr,
input wr,
// data ipnut
input [W-1:0] d,

// data output
output reg[W-1:0] q
);

// data RAM array
reg[W-1:0] rq, arr[0:511];

always@( posedge clk or negedge clrn )
	q <= (!clrn) ? 0 : rq;

always@( posedge clk ) begin
	if( wr ) arr[wradr] <= d;
	rq <= arr[rdadr];
end
	
	
	
endmodule


















