`include "defines.v"
`include "rom_st_last.v"

module clk_control
(
// global clock/reset inputs
input clk, clrn,
// input config
input mck_mode, mck_div,
input[1:0] ovs_max,
input sai_lrc,

// output config
output[2:0] st_last, ofs_in,
output mcko, bypass
);

// control registers
reg[1:0] rlrc;
reg[10:0] rcnt, rval;
reg rmck;

// control signals
reg[2:0] rfs_in, rst_last;
reg rbypass;
wire[2:0] wst_last;
wire wbypass;

// output assigments
assign st_last = rst_last;
assign ofs_in = rfs_in;
assign mcko = (mck_div) ? rmck : clk;
assign bypass = rbypass;

always@( posedge clk, negedge clrn ) begin
	if( !clrn ) begin
		rlrc <= 0; rcnt <= 0; rval <= 11'h7ff;
		rfs_in <= 0; rst_last <= 0; rbypass <= 0;
	end
	else begin
		rmck <= ~rmck;
		rlrc <= {rlrc[0], sai_lrc};		
		
		if( !rlrc[1] && rlrc[0] ) begin		
			rcnt <= 0;
			rval <= rcnt;
	
			if( mck_mode == 0 ) begin
				if( rval < 96 ) rfs_in <= 5;
				else if( rval < 192 ) rfs_in <= 4;
				else if( rval < 384 ) rfs_in <= 3;
				else if( rval < 768 ) rfs_in <= 2;
				else rfs_in <= 1;
			end
			else if( mck_mode == 1 ) begin
				if( rval < 72 ) rfs_in <= 5;
				else if( rval < 144 ) rfs_in <= 4;
				else if( rval < 288 ) rfs_in <= 3;
				else if( rval < 576 ) rfs_in <= 2;
				else rfs_in <= 1;
			end
		
			rst_last <= wst_last;
		end
		else
			rcnt <= rcnt + 1;

		rbypass <= wbypass;
	end
end


rom_st_last __rom_st_last(
	// input control
	.adr( {rfs_in, ovs_max} ),

	// output config
	.q( wst_last ),
	.bypass( wbypass )
);


endmodule










