module Mac_Wx9_L
#( parameter W = 32, WA = 38 )
(
// input global signals
input clk, clrn,
// input sync signals
input read, start, sinena, shsena, rndena, accena,
// input data
input signed[W-1:0] d,
// input coef
input[8:0] c,
// input round value
input signed[8:0] r,

// output data
output signed[W-1:0] q
);

// input data sum registers
wire signed[W+9:0] din = d;
reg signed[W+9:0] dbuf, dsum;
// multiplier registers
reg signed[W+9:0] st1[0:4], st2[0:2], st3[0:1], st4, stsum;
// accumulator register
reg signed[WA-1:0] acc;
// sign processing
wire wsign = sinena & c[8];
wire wval = ~sinena & c[8];
// round processing
wire signed[W+9:0] round = r;

// variables
integer i;

// output assigments
assign q = (acc >> (WA-W));

// mac sync logic
always@( posedge clk or negedge clrn ) begin
	if( !clrn )begin
		// negative global reset - set all registers to zero
		dbuf <= 0; dsum <= 0;
		st1[0] <= 0; st1[1] <= 0; st1[2] <= 0; st1[3] <= 0; st1[4] <= 0;
		st2[0] <= 0; st2[1] <= 0; st2[2] <= 0;
		st3[0] <= 0; st3[1] <= 0;
		st4 <= 0;
		stsum <= 0;
		acc <= 0;
	end
	else begin
		// input data load & summation
		if( start ) dbuf <= din;
		if( sinena ) dsum <= dbuf + din * read;
		
		// 1 stage multiplier
		`ifndef MULT_DEDICATED_ENA
		for( i=0; i<4; i=i+1 ) st1[i] <= (dsum << 1) * c[i*2+1] + dsum * c[i*2];
		`endif
		`ifdef MULT_DEDICATED_ENA
		st1[0] <= $signed( dsum[W:0] ) * $signed( {1'b0, c[7:0]} );
		`endif
		
		st1[4] <= dsum * wval + ~dsum * wsign + wsign; // sign processing
			
		// 2 stage multiplier
		`ifndef MULT_DEDICATED_ENA
		for( i=0; i<2; i=i+1 ) st2[i] <= (st1[i*2+1] << 2) + st1[i*2];
		`endif
		`ifdef MULT_DEDICATED_ENA
		st2[0] <= st1[0];
		`endif
	
		st2[2] <= (st1[4] << 8) + (round << 1) * rndena; // round processing
		
		// 3 stage multiplier
		`ifndef MULT_DEDICATED_ENA
		st3[0] <= (st2[1] << 4) + st2[0];
		`endif
		`ifdef MULT_DEDICATED_ENA
		st3[0] <= st2[0];
		`endif
		
		st3[1] <= st2[2];
		
		// 4 stage multiplier
		st4 <= st3[1] + st3[0];
		
		// stage shift summation
		stsum <= {{9{stsum[W+9]}}, stsum[W+9:9]} * shsena + st4;

		// accumulator processing
		if( shsena == 0 ) acc <= acc * accena + ({stsum, 9'h0} >> (W+17-WA));
	end
end
		




endmodule
















