`include "defines.v"

`define POLYNOM		(21'h150b11)
//`define POLYNOM		(21'h140000)
//`define POLYNOM		(21'h1c8000)

module NoiseShape
(
// input global sync signals
input clk, clrn,
// input control signals
input next, dithen, shpen,
input[2:0] d_len,

// parallel data output
output signed[24:0] q
);

// LFSR register
reg[20:0] lfsr;
wire ilfsr = (dithen) ? ( (lfsr) ? lfsr[0] : 1 ) : 0;

// IIR high pass butterworth 1-st order
reg signed[8:0] random;
reg signed[10:0] rzn;
reg signed[9:0] shape;

// nois shape signals
reg signed[10:0] rc1;
reg signed[10:0] rc21;
reg signed[10:0] sum1, sum2;

// output round
reg signed[9:0] wrndval;
reg signed[23:0] round;

// output assigment
assign q = round;

// set shaping range from data width
always@( 1 ) begin
	rc1 = random;
	rc21 = (rzn >>> 1);
	sum1 = rc1 - rc21;
	sum2 = sum1 - rzn;

	case( d_len ) // 0.5LSB form
	`DATA_16bit: wrndval = 'sh100;
	`DATA_18bit: wrndval = 'sh040;
	`DATA_20bit: wrndval = 'sh010;
	`DATA_22bit: wrndval = 'sh004;
	`DATA_24bit: wrndval = 'sh001;
	default: wrndval = 'sh001;
	endcase
	
	case( d_len )
	`DATA_16bit: random = lfsr[8:0];
	`DATA_18bit: random = { {2{lfsr[6]}}, lfsr[6:0] };
	`DATA_20bit: random = { {4{lfsr[4]}}, lfsr[4:0] };
	`DATA_22bit: random = { {6{lfsr[2]}}, lfsr[2:0] };
	`DATA_24bit: random = 0;
	default: random = 0;
	endcase
end

// input shift registers in input clock domain
always@( posedge clk or negedge clrn ) begin
	if( !clrn ) begin
		lfsr <= 0; rzn <= 0; shape <= 0; round <= 0;
	end
	else if( next ) begin
		// rundom generate
		lfsr <= (lfsr >> 1) ^ (`POLYNOM * ilfsr);
	
		// IIR delay processing
		rzn <= sum1;
		shape <= (shpen) ? (sum2 >>> 2) : random;
		
		// round to +/-0.5LSB processing
		round <= (shape << 1) + wrndval;
	end
end




endmodule










