`include "defines.v"

`include "SAI_input.v"
`include "DF1_FIR_CORE.v"
`include "SAI_output.v"
`include "altpll0.v"

	
module DF1
(
// global clock/reset inputs
input clk, 				// global master-clock input
input clki, 				// global master-clock input
input clrn, 			// global nReset input (active low)
input oscsel, 			// osc clock domen select: 0 - osc1ena, 1 - osc2ena
// ------------------------  Config ports -------------------------------------------------------------------------
// clock config

input mute,				// soft mute input signal (active high)
input lp_mode,			// 1 - enable low power mode
input dithen,
input shpen,
// output data format config

input dg_inv, 			// 1 - force bck inversion
input bck_inv,


// led indicator outputs (active low)
output[2:0] ovs_ind,
output clipping,

output LED_44,
output LED_48,
output LED_88,
output LED_96,
output LED_176,
output LED_192,
output LED_352,
output LED_384,

// SAI input data signals
input sai_dat, sai_sck, sai_lrc,

// output SPI (or PCM) data signals
output dat1_left, dat1_right, bck1, wck1, ltch1,
output dat2_left, dat2_right, bck2, wck2, ltch2,
output dat3_left, dat3_right, bck3, wck3, ltch3,
output dat4_left, dat4_right, bck4, wck4, ltch4,
output dg,
output clk2,

// clock control outputs
output osc1ena, osc2ena,	// oscillator controls
output mcko			// master-clock output for feedback sync
);

//config default

// ------------------------Config ports default -------------------------------------------------------------------------
// clock config
wire mck_mode=0;		// input clock multiplicity: 0 - 1024Fs, 1 - 768Fs
wire mck_div=1;			// otput mck divider: 0 - clk/1, 1 - clk/2
//wire mute=1;
//wire oscsel=0;			// osc clock domen select: 0 - osc1ena, 1 - osc2ena

// FIR filter config
//wire lp_mode=0;			// 1 - enable low power mode
wire[1:0] att=0;			// attenuation input signal: 0 - 0db, 1 - 1db, 2 - 2db, 3 - 3db
wire[1:0] ovs_max=3; 	// max oversampling 0..3 - x4..x32

// input config
wire[1:0] format=0; 		// 0 - I2S, 1 - LJ, 2 - RJ24, 3 - RJ16
wire[1:0] frame=0;		// input frame lenth: 0 (or 3) - 64bit, 1 - 48bit, 2 - 32bit

// output data format config
wire ob_ntwc=1; 			// 1 - offset binary, 0 - 2's complement
wire[2:0] d_width=0; 	// data lenth 0..4 - 16bit..24 bit (2bit step), 5 - 32bit, 6..7 - bck_continue mode (24bit - right justified)
wire[2:0] d_speed=3; 	// data rate 0..5 - clk/1, clk/2, clk/3, clk/4, clk/6, clk/8
wire[1:0] spi_dsize=0;	// SPI data field lenth 0 - = d_width, 1 - 16bit, 2 - 20bit, 3 - 24bit
wire[2:0] spi_mode=2;	// 0 - diff, 1 - diff serial, 2 - conv, 3 - conv serial, 4 - channels serial
wire[2:0] head_mode=0;	// 0 - no header, 1 - DAC8812 head, 2 - AD5791 head, 3 - AD5063 head, 4 - DAC11001 head, 5 - LTC1592 head, 6 - LTC2752 head, 7 - reserved
wire outZ=0;				// 1 - force spi output both channals (dat, bck and wck) to Z-state.
wire outInv=0;			// 1 - invert serial outputs both channels: dat, wck and lutch.

// deglitcher config
//wire dg_inv=0;			// deglitcher signal invertion
wire dg_pp=0;			// deglitcher pipeline mode
wire dg_off=0;			// logic 1 - turn deglitching sirciut to always sample state (off state)
wire[1:0] dgh_mode=0; 	// deglitcher rise front mode
wire[1:0] dgl_mode=0;	// deglitcher fall front mode if spi_dsize == 0 then (0 - rise wck, 1 - fall wck, 2 - pcm1704 mode, 3 - pcm1702 mode), else (0 - rise wck, 1 - fall latch)
// ----------------------------------------------------------------------------------------------------------------


// control registers
reg[16:0] rclip;

// SAI_input outputs
wire sai_in_rdy;
wire signed[`BUS_WIDTH-1:0] sai_d_left, sai_d_right;

// fir_lp_stereo_27bit outputs
wire signed[23:0] fir_out_left, fir_out_right;
wire[2:0] wfs_in;
wire wclip, wbypass;

// SAI_Output outputs
wire sai_out_load;

// output assigments
assign osc1ena = (~oscsel);
assign osc2ena = oscsel;
assign clipping = (~rclip[16]);

assign dat3_left = dat1_left;
assign dat4_left = dat2_left;
assign dat3_right = dat1_right;
assign dat4_right = dat2_right;
assign bck3 = bck1;
assign bck4 = bck2;
assign wck3 = wck1;
assign wck4 = wck2;
assign ltch3 = ltch1;
assign ltch4 = ltch2;

//assign ovs_ind = wfs_in - 1;
//assign ovs_ind = (wbypass) ? 0 : (~wfs_in);
assign ovs_ind = ~((wbypass) ? 0 : ( ~(wfs_in - 1) ));

//LED_decoder
assign	LED_44 = (wfs_in == 1) ? osc1ena : 0;
assign	LED_88 = (wfs_in == 2) ? osc1ena : 0;
assign	LED_176 = (wfs_in == 3) ? osc1ena : 0;
assign	LED_352 = (wfs_in == 4) ? osc1ena : 0;

assign	LED_48 = (wfs_in == 1) ? osc2ena : 0;
assign	LED_96 = (wfs_in == 2) ? osc2ena : 0;
assign	LED_192 = (wfs_in == 3) ? osc2ena : 0;
assign	LED_384 = (wfs_in == 4) ? osc2ena : 0;

//always@ (1) begin
//LED_44 = (wfs_in == 1) ? osc1ena : 0;
//LED_88 = (wfs_in == 2) ? osc1ena : 0;
//LED_176 = (wfs_in == 3) ? osc1ena : 0;
//LED_352 = (wfs_in == 4) ? osc1ena : 0;

//LED_48 = (wfs_in == 1) ? osc2ena : 0;
//LED_96 = (wfs_in == 2) ? osc2ena : 0;
//LED_192 = (wfs_in == 3) ? osc2ena : 0;
//LED_384 = (wfs_in == 4) ? osc2ena : 0;
//end

wire sclip = ~rclip[16] & sai_in_rdy;

// digital clipping indication
always@( posedge clk or negedge wclip ) begin
	rclip <= (!wclip) ? 0 : (rclip + sclip);
end

SAI_input __sai_input(
	// global clock/reset inputs
	.clk( clk ), .clrn( clrn ),
	// control inputs
	.mute( mute ),
	.format( format ), .frame( frame ), .att( att ),
	// serial data input
	.sai_dat( sai_dat ), .sai_sck( sai_sck ), .sai_lrc( sai_lrc ),

	// parallel data output
	.q_left( sai_d_left ), .q_right( sai_d_right ),
	.ready( sai_in_rdy )
);

DF1_FIR_CORE __fir(
	// global clock/reset inputs
	.clk( clk ), .clrn( clrn ), .mck_mode( mck_mode ), .mck_div( mck_div ),
	// setting inputs
	.sai_lrc( sai_lrc ), .lp_mode( lp_mode ), .dithen( dithen ), .shpen( shpen ),
	.ovs_max( ovs_max ), .att( att ),
	.d_width( d_width ),
	// control inputs
	.in_ready( sai_in_rdy ), .out_load( sai_out_load ),
	// input data
	.d_left( sai_d_left ), .d_right( sai_d_right ),

	// output data
	.q_left( fir_out_left ), .q_right( fir_out_right ),
	.fs_in( wfs_in ),
	.mcko( mcko ), .clipn( wclip ), .bypass( wbypass )
);

SAI_output __sai_output(
	// input global signals
	.clk( clk ), .clrn( clrn ), .mck_mode( mck_mode ),
	// input control signals
	.ob_ntwc( ob_ntwc ), .bck_inv( bck_inv ), .dg_inv( dg_inv ), .dg_pp( dg_pp ), .dg_off( dg_off ), .outZ( outZ ), .outInv( outInv ),
	.ovs_max( ovs_max ), .spi_dsize( spi_dsize ), .dgh_mode( dgh_mode ), .dgl_mode( dgl_mode ),
	.d_width( d_width ), .d_speed( d_speed ), .spi_mode( spi_mode ), .head_mode( head_mode ),
	// input data
	.d_left( fir_out_left ), .d_right( fir_out_right ),

	// output control
	.load( sai_out_load ),
	// output data
	.dat1_left( dat1_left ), .dat1_right( dat1_right ), .bck1( bck1 ), .wck1( wck1 ), .ltch1( ltch1 ),
	.dat2_left( dat2_left ), .dat2_right( dat2_right ), .bck2( bck2 ), .wck2( wck2 ), .ltch2( ltch2 ),
	.dg( dg )
);

altpll0 _pll(
	.areset( 1'b0 ),
	.inclk0( clki ),
	.c0( clk2 ),
	.locked()
);










endmodule







