`include "defines.v"
`include "att_4x12.v"


module SAI_input
(
// input global sync signals
input clk, clrn,
// control inputs
input mute,
input[1:0] format, frame, att,
// serial data input
input sai_dat, sai_sck, sai_lrc,

// parallel data output
output signed[`BUS_WIDTH-1:0] q_left, q_right,
output ready
);

// control registers
reg rdy, start;
reg[1:0] rlrc, sync;

// data registers
reg signed[31:0] shreg, rbuf;
reg signed[35:0] rleft;
reg rdel;

// data signals
wire signed[35:0] wqatt;
wire signed[35:0] wLeft = rleft;
wire signed[35:0] wRight = {rbuf, 4'h0};

// control signals
wire wlrc_inv = (format == `FORMAT_I2S) ? 1 : 0;
wire wload = rlrc[0] ^ rlrc[1];
wire wlrc = (format) ? sai_lrc : (~sai_lrc);
wire attrdy;

// output assigments
assign q_left = wLeft >>> (37 - `BUS_WIDTH);
	`ifdef INPUT_ATT_ENA
assign q_right = wqatt >>> (37 - `BUS_WIDTH);
	`else
assign q_right = wRight >>> (37 - `BUS_WIDTH);
	`endif
assign ready = rdy;


// input shift registers in input clock domain
always@( posedge sai_sck or posedge mute ) begin
	if( mute ) begin
		shreg <= 0; rbuf <= 0; rleft <= 0; rdel <= 0;
	end
	else begin
		rdel <= sai_dat;
		
		if( frame == `FRAME_BCK64 || frame == `FRAME_DEFAULT ) begin
			case( format )
			`FORMAT_I2S: shreg <= {shreg[30:0], sai_dat};
			`FORMAT_LJ: shreg <= {shreg[30:0], rdel};
			`FORMAT_RJ24: shreg <= {shreg[30:8], rdel, shreg[7:0]};
			`FORMAT_RJ16: shreg <= {shreg[30:16], rdel, shreg[15:0]};
			endcase
		end
		else if( frame == `FRAME_BCK48 ) begin
			case( format )
			`FORMAT_I2S: shreg <= {shreg[30:8], sai_dat, shreg[7:0]};
			`FORMAT_LJ: shreg <= {shreg[30:8], rdel, shreg[7:0]};
			`FORMAT_RJ24: shreg <= {shreg[30:8], rdel, shreg[7:0]};
			`FORMAT_RJ16: shreg <= {shreg[30:16], rdel, shreg[15:0]};
			endcase 
		end
		else if( frame == `FRAME_BCK32 ) begin
			case( format )
			`FORMAT_I2S: shreg <= {shreg[30:16], sai_dat, shreg[15:0]};
			`FORMAT_LJ: shreg <= {shreg[30:16], rdel, shreg[15:0]};
			`FORMAT_RJ24: shreg <= {shreg[30:16], rdel, shreg[15:0]};
			`FORMAT_RJ16: shreg <= {shreg[30:16], rdel, shreg[15:0]};
			endcase
		end

		if( wload ) rbuf <= shreg;
		
			`ifdef INPUT_ATT_ENA
		if( wload ) rleft <= wqatt;
			`else
		if( wload ) rleft <= {rbuf, 4'h0};
			`endif
	end
end

// control registers in input clock domain
always@( posedge sai_sck or negedge clrn )
	rlrc <= (!clrn) ? 0 : {rlrc[0], (sai_lrc ^ wlrc_inv)};

// control syncronisation to base clock domain
always@( posedge clk or negedge clrn ) begin
	sync <= (!clrn) ? 0 : {sync[0], wload};
	start <= (!clrn) ? 0 : (sync[1] && !sync[0]);
	
		`ifdef INPUT_ATT_ENA	
	rdy <= (!clrn) ? 0 : (rlrc[1] & attrdy);
		`else
	rdy <= (!clrn) ? 0 : (sync[1] && !sync[0] && rlrc[1]);
		`endif
end

att_4x12
#( .WR( `ATT_DITH_WIDTH ) )
__att_4x12(
	// input global sync signals
	.clk( clk ), .clrn( clrn ), .start( start ),
	// control inputs
	.att( att ),
	// data input
	.d( rbuf ),

	// parallel data output
	.q( wqatt ),
	.ready( attrdy )
);

endmodule










