module rom_dg_hi
(
// input control
input[4:0] adr,

// output data
output reg[7:0] q
);

always@( 1 ) begin

	case( adr ) // {ovs_max, mck_mode, dgh_mode}
	//ovs_max == `OVS_MAX_x4  mck_mode == 0
	0: q = 128;	
	1: q = 136;
	2: q = 144;
	3: q = 152;
	
	//ovs_max == `OVS_MAX_x4  mck_mode == 1
	4: q = 96;
	5: q = 104;
	6: q = 112;
	7: q = 120;
	
	//ovs_max == `OVS_MAX_x8  mck_mode == 0
	8: q = 64;
	9: q = 68;
	10: q = 72;
	11: q = 76;
	
	//ovs_max == `OVS_MAX_x8  mck_mode == 1
	12: q = 48;
	13: q = 52;
	14: q = 56;
	15: q = 60;
	
	//ovs_max == `OVS_MAX_x16  mck_mode == 0
	16: q = 32;
	17: q = 34;
	18: q = 36;
	19: q = 38;
	
	//ovs_max == `OVS_MAX_x16  mck_mode == 1
	20: q = 24;
	21: q = 26;
	22: q = 28;
	23: q = 30;
	
	//ovs_max == `OVS_MAX_x32  mck_mode == 0
	24: q = 16;
	25: q = 17;
	26: q = 18;
	27: q = 19;
	
	//ovs_max == `OVS_MAX_x32  mck_mode == 1
	28: q = 12;
	29: q = 13;
	30: q = 14;
	31: q = 15;
	endcase
end

endmodule






