`include "defines.v"

`ifdef LOGIC_STYLE_ALTERA
	`include "Mac_Wx9_A.v"
	`define MAC_MODULE	Mac_Wx9_A
`endif
`ifdef LOGIC_STYLE_LATTICE
	`include "Mac_Wx9_L.v"
	`define MAC_MODULE	Mac_Wx9_L
`endif

`define POLYNOM_MAC		(25'h1b88c11)

module mac_control
(
// input global signals
input clk, clrn,
input[1:0] sync,
// input sync signals
input[2:0] st_read, st_last,
input read, start,
// input data
input signed[`BUS_WIDTH-1:0] d_left, d_right,
// input coef
input[8:0] coef,

// output data
output signed[`BUS_WIDTH-1:0] q_left, q_right,
// output global signals
output[2:0] st_write
);

// control registers
reg[2:0] rstg[0:3];
reg sinena, shsena, rndena, accena;
reg[24:0] lfsr;

// round processing signals
wire signed[7:0] random = lfsr << (8 - `MAC_DITH_WIDTH);
reg signed[8:0] rrnd;
wire ilfsr = (lfsr) ? lfsr[0] : 1;	// start load lfsr with non zero value

// output assigments
assign st_write = rstg[3];

// mac control logic
always@( posedge clk or negedge clrn ) begin
	if( !clrn )begin
		// negative global reset - set all registers to zero
		rstg[0] <= 0; rstg[1] <= 0; rstg[2] <= 0; rstg[3] <= 0; 
		sinena <= 0; shsena <= 0; rndena <= 0; accena <= 0;
		lfsr <= 0; rrnd <= 0;
	end
	else begin
		if( sync == 2 ) begin
			rstg[0] <= st_read;
			rstg[1] <= (rstg[0] == st_last) ? 5 : rstg[0];
			rstg[2] <= (rstg[1]) ? rstg[1] + 1 : rstg[1];
			rstg[3] <= (sync == 2) ? rstg[2] : 0;
			
			accena <= (rstg[3]) ? 0 : 1;
		end
		
		sinena <= (sync == 1) ? 1 : 0;
		shsena <= (sync) ? 1 : 0;
		rndena <= (rstg[1]) ? sinena : 0;
		
		// random generate
		if( st_read ) begin
			lfsr <= (lfsr >> 1) ^ (`POLYNOM_MAC * ilfsr);
			rrnd <= random + 'sh40;
		end
	end
end

`MAC_MODULE #( .W( `BUS_WIDTH ), .WA( `ACC_WIDTH ) )
mac_left(
	// input global signals
	.clk( clk ), .clrn( clrn ),
	// input sync signals
	.read( read ), .start( start ), .sinena( sinena ), .shsena( shsena ), .rndena( rndena ), .accena( accena ),
	// input data W bit
	.d( d_left ),
	// input coef 9 bit
	.c( coef ),
	// input round value
	.r( rrnd ),
	// output data
	.q( q_left )
);

`MAC_MODULE #( .W( `BUS_WIDTH ), .WA( `ACC_WIDTH ) )
mac_right(
	// input global signals
	.clk( clk ), .clrn( clrn ),
	// input sync signals
	.read( read ), .start( start ), .sinena( sinena ), .shsena( shsena ), .rndena( rndena ), .accena( accena ),
	// input data W bit
	.d( d_right ),
	// input coef 9 bit
	.c( coef ),
	// input round value
	.r( rrnd ),
	// output data
	.q( q_right )
);


endmodule
















