`include "defines.v"

	`ifdef BLOCK_RAM_SIZE_4K
`include "coef_M4K_0.v"
`include "coef_M4K_1.v"
`include "coef_M4K_2.v"
`include "coef_M4K_3.v"
`include "coef_M4K_4.v"
`include "coef_M4K_5.v"
`include "coef_M4K_6.v"
`include "coef_M4K_7.v"
	`endif

	`ifdef BLOCK_RAM_SIZE_9K
`include "coef_M9K_0.v"
`include "coef_M9K_1.v"
`include "coef_M9K_2.v"
`include "coef_M9K_3.v"
	`endif

module coef_rom_9x4096
(
// input global sync signals
input clk, clrn,
// control input
input[11:0] adr,

// data output
output[8:0] q
);

// data registers
reg[8:0] rq;
// control registers
reg[2:0] sw;
// midmodules interconnects
wire[8:0] wq[0:7];
// output assigment
assign q = rq;

	`ifdef BLOCK_RAM_SIZE_4K
always@( posedge clk or negedge clrn ) begin	
	sw <= (!clrn) ? 0 : adr[11:9];
	rq <= (!clrn) ? 0 : wq[sw];
end

coef_M4K_0 __rom0( .clk( clk ), .adr( adr[8:0] ), .q( wq[0] ) );
coef_M4K_1 __rom1( .clk( clk ), .adr( adr[8:0] ), .q( wq[1] ) );
coef_M4K_2 __rom2( .clk( clk ), .adr( adr[8:0] ), .q( wq[2] ) );
coef_M4K_3 __rom3( .clk( clk ), .adr( adr[8:0] ), .q( wq[3] ) );
coef_M4K_4 __rom4( .clk( clk ), .adr( adr[8:0] ), .q( wq[4] ) );
coef_M4K_5 __rom5( .clk( clk ), .adr( adr[8:0] ), .q( wq[5] ) );
coef_M4K_6 __rom6( .clk( clk ), .adr( adr[8:0] ), .q( wq[6] ) );
coef_M4K_7 __rom7( .clk( clk ), .adr( adr[8:0] ), .q( wq[7] ) );
	`endif
	
	`ifdef BLOCK_RAM_SIZE_9K
always@( posedge clk or negedge clrn ) begin	
	sw <= (!clrn) ? 0 : adr[11:10];
	rq <= (!clrn) ? 0 : wq[sw];
end

coef_M9K_0 __rom0( .clk( clk ), .adr( adr[9:0] ), .q( wq[0] ) );
coef_M9K_1 __rom1( .clk( clk ), .adr( adr[9:0] ), .q( wq[1] ) );
coef_M9K_2 __rom2( .clk( clk ), .adr( adr[9:0] ), .q( wq[2] ) );
coef_M9K_3 __rom3( .clk( clk ), .adr( adr[9:0] ), .q( wq[3] ) );
	`endif



endmodule



