`include "defines.v"

	`ifdef BLOCK_RAM_SIZE_4K
`include "coef_M4K_0.v"
`include "coef_M4K_1.v"
	`endif

	`ifdef BLOCK_RAM_SIZE_9K
`include "coef_M9K_0.v"
	`endif

module coef_rom_9x1024
(
// input global sync signals
input clk, clrn,
// control input
input[9:0] adr,

// data output
output[8:0] q
);

// data registers
reg[8:0] rq;
wire[8:0] wq[0:1];

// control registers
reg rsw;

// output assigment
assign q = rq;

	`ifdef BLOCK_RAM_SIZE_4K
always@( posedge clk or negedge clrn ) begin
	rsw <= (!clrn) ? 0 : adr[9];
	rq <= (!clrn) ? 0 : ( (rsw) ? wq[1] : wq[0] );
end

coef_M4K_0 __coef_rom0( .clk( clk ), .adr( adr[8:0] ), .q( wq[0] ) );
coef_M4K_1 __coef_rom1( .clk( clk ), .adr( adr[8:0] ), .q( wq[1] ) );
	`endif
	
	`ifdef BLOCK_RAM_SIZE_9K
always@( posedge clk or negedge clrn )
	rq <= (!clrn) ? 0 : wq[0];	

coef_M9K_0 __coef_rom0( .clk( clk ), .adr( adr ), .q( wq[0] ) );
	`endif


endmodule

