#ifndef _PORT_H_    /* Guard against multiple inclusion */
#define _PORT_H_


/* Provide C++ Compatibility */
#ifdef __cplusplus
extern "C" {
#endif

    
#define _BIT(bit_num)                   ((uint32_t)(0x01 << (bit_num)))
    
#define OSC_44K_ON()                    LATESET = _BIT(3)          // set osc44k to high
#define OSC_44K_OFF()                   LATECLR = _BIT(3)          // set osc44k to low

#define OSC_48K_ON()                    LATESET = _BIT(4)          // set osc48k to high
#define OSC_48K_OFF()                   LATECLR = _BIT(4)          // set osc48k to low
    
#define FS0_SET_HIGH()                  LATESET = _BIT(1)          // MO CS5381
#define FS0_SET_LOW()                   LATECLR = _BIT(1)          

#define FS1_SET_HIGH()                  LATESET = _BIT(2)          // M1 CS5381
#define FS1_SET_LOW()                   LATECLR = _BIT(2)
    
#define PIC_RESET5381_HIGH()            LATBSET = _BIT(4)          // reset high CS5381  
#define PIC_RESET5381_LOW()             LATBCLR = _BIT(4)          // reset low CS5381 
    
#define PIC_DATAFLOW_ON()               LATCSET = _BIT(14)          // data flow on from CS5381 
#define PIC_DATAFLOW_OFF()              LATCCLR = _BIT(14)          // data flow off from CS5381
    
// Turn On exteral interrupt on LRCK input pin
#define _PORT_Input_Transfer_Sync()     IEC0SET = _IEC0_INT1IE_MASK

    
    
    
void port_init (void);




    /* Provide C++ Compatibility */
#ifdef __cplusplus
}
#endif

#endif /* _PORT_H_ */


