
#include "../../app/system.h"
#include "port.h"




/*
 port_init() - mcu port power up initialisation
 */
void port_init (void)
{ 
    OSC_44K_ON();                      // set OSC to 44k domain
    OSC_48K_OFF();
    FS0_SET_LOW();                     // set CS5381 to single speed
    FS1_SET_LOW();
    PIC_RESET5381_HIGH();              // reset high to CS5381
    PIC_DATAFLOW_OFF();                // data flow off
    
    /*Configure ports direction. 1 - input, 0 - output*/
    TRISECLR = _BIT(1) | _BIT(2) | _BIT(3) | _BIT(4);// M0,M1 ADC settings, OSC 44k, 48k
    TRISBCLR = _BIT(4);                              // reset CS5381
    TRISCCLR = _BIT(14);                             // data flow
    ANSELGCLR = _BIT(6) | _BIT(7) | _BIT(9);         // Switch Off Analog Function for I2S inputs
            
    /*Configure ports Pull Up. 1 - pull enable*/
    CNPUFSET = _BIT(3); // USBID input Pull-Up
    
    /*Configure ports Pull Down. 1 - pull enable*/
    CNPDBSET = _BIT(2) | _BIT(3) | _BIT(6) | _BIT(7) | _BIT(8) | _BIT(9) | _BIT(10) | _BIT(11) | _BIT(12) | _BIT(13) | _BIT(14) | _BIT(15);
    CNPDCSET = _BIT(13) |  _BIT(15);
    CNPDDSET = _BIT(0) | _BIT(1) | _BIT(2) | _BIT(3) | _BIT(4) | _BIT(5) | _BIT(9) | _BIT(10) | _BIT(11);
    CNPDESET = _BIT(0) | _BIT(5) | _BIT(6) | _BIT(7);
    CNPDFSET = _BIT(0) | _BIT(1) |_BIT(4) | _BIT(5);
    CNPDGSET = _BIT(8);
    
    /************ Remappable pins *******************/    
    // I2S2 remappable inputs
    SDI2R = 0x1;    // 0001 = RPG7 - SDI2
    SS2R = 0x1;     // 0001 = RPG9 - SS2in
    
    // External Interrupt input for I2S2 input channels syncronisation
    INT1R = 0x1;    // 0001 = RPG9 - SS2in
    INTCONbits.INT1EP = 0; // External Interrupt 1 Edge Polarity, 1 = Rising edge, 0 = Falling edge    
    IPC2SET = 0
            | (0x7 << _IPC2_INT1IP_POSITION)    // Set maximum priority level to correct start I2S input
            | (0x3 << _IPC2_INT1IS_POSITION)
            ;    
    IFS0bits.INT1IF = 0;
}

/*
 * EXT1_Interrupt()
*/
void __ISR(_EXTERNAL_1_VECTOR, ipl7SRS) EXT1_Interrupt(void)
{
    _I2S_Input_Transfer_Start();    // Turn ON I2S2 on Falling edge RLCK input
    _DMA_Input_Transfer_Start();
    IEC0CLR = _IEC0_INT1IE_MASK;    // Disable EXTI1 interrupts
    IFS0CLR = _IFS0_INT1IF_MASK;    // Clear interupt flag
}
