

#include "../../app/system.h"
#include "i2s.h"



/*
 SPI based I2S modules initialisation  
 */
void i2s_init (void)
{
    /**************************************************************************/
    /* I2S2 input module initialisation                                       */
    /**************************************************************************/
    SPI2CON2 = 0
            | _SPI2CON2_AUDEN_MASK      // Audio protocol enabled
            | (0x1 << _SPI2CON2_AUDMOD_POSITION) // Left-Justified mode
            | _SPI2CON2_IGNROV_MASK     // A ROV is not a critical error; during ROV data in the FIFO is not overwritten by receive data            
            ;    
    SPI2CON = 0
            | _SPI2CON_FRMPOL_MASK      // Frame Sync Polarity
            | _SPI2CON_MCLKSEL_MASK     // MCLK is used by the Baud Rate Generator
            | _SPI2CON_SSEN_MASK        // SSx pin used for Slave mode
            | _SPI2CON_ENHBUF_MASK      // Enhanced Buffer mode is enabled
            | _SPI2CON_MODE32_MASK      // 32-bit Data, 32-bit FIFO, 32-bit Channel/64-bit Frame
            | _SPI2CON_CKP_MASK         // Idle state for clock is a high level; active state is a low leve
            | _SPI2CON_DISSDO_MASK      // SDOx pin is not used by the SPI module (pin is controlled by PORT function)
            | (0x1 << _SPI2CON_SRXISEL_POSITION) // see lower            
                //SRXISEL<1:0>: SPI Receive Buffer Full Interrupt Mode bits
                //11 = Interrupt is generated when the buffer is full
                //10 = Interrupt is generated when the buffer is full by one-half or more
                //01 = Interrupt is generated when the buffer is not empty
                //00 = Interrupt is generated when the last word in the receive buffer is read (i.e., buffer is empty)
            ;
    // Set interupt priority on I2S input
    IPC35SET = 0
            | (0x4 << _IPC35_SPI2RXIP_POSITION)        // SPI2 RX Interrupt Priority
            | (0x0 << _IPC35_SPI2RXIS_POSITION)        // SPI2 RX Interrupt Sub-Priority
            ;
    
    _CLK_I2S_ON();
}










