
#include "../../app/system.h"
#include "dma.h"





/*
 * dma_init()
 */
void dma_init (void)
{
    
    DMACONbits.ON = 1;                          // Enable DMA controller
    
    /**************************************************************************/
    /* Channel 5 config - to copy data from I2S2 module to EP5 FIFO buffer    */
    /**************************************************************************/
    DCH5SSA = KVA_TO_PA( &SPI2BUF );            // Source data start address (I2S2 FIFO buffer)
    DCH5SSIZ = 4;                               // Source data saze (I2S FIFO data size - 4 bytes)
    DCH5CSIZ = 4;                               // Cell data size: channel audio data size (4 bytes)
    DCH5CONbits.CHAEN = 1;                      // Channel is continuously enabled, and not automatically disabled after a block transfer is complete
    // Only separate fields support!!!!
    DCH5ECONbits.CHSIRQ = _SPI2_RX_VECTOR;      // Channel Transfer Start IRQ
    DCH5ECONbits.SIRQEN = 1;                    // Enable transfer IRQ
}








