
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <sys/attribs.h>
#include <xc.h>


#include "sdm3.h"



uint32_t bitStream = 0;
int sdmSum[8*3] = {0};
int sdmAcc[8*3] = {0};
int sdmOutSum[8] = {0};

uint32_t sdm3_frame8 (int din)
{
    LATBSET = (0x01 << 5);
            
    bitStream |= sdmOutSum[0];
    bitStream >>= 1;
    bitStream |= sdmOutSum[1];
    bitStream >>= 1;
    bitStream |= sdmOutSum[2];
    bitStream >>= 1;
    bitStream |= sdmOutSum[3];
    bitStream >>= 1;
    bitStream |= sdmOutSum[4];
    bitStream >>= 1;
    bitStream |= sdmOutSum[5];
    bitStream >>= 1;
    bitStream |= sdmOutSum[6];
    bitStream >>= 1;
    bitStream |= sdmOutSum[7];
    bitStream >>= 1;
    
    sdmSum[0] = sdmAcc[0] + (din >> 1) - sdmOutSum[0];
    sdmSum[1] = sdmAcc[1] + (sdmAcc[0] >> 1) - (sdmAcc[2] >> 9);
    sdmSum[2] = sdmAcc[2] + (sdmAcc[0] >> 2);    
    sdmOutSum[0] = sdmSum[0] + sdmSum[1] + sdmSum[2];
    sdmOutSum[0] <<= 1;
    sdmOutSum[0] &= 0x80000000;

    sdmSum[3] = sdmAcc[3] + (din >> 1) - sdmOutSum[1];
    sdmSum[4] = sdmAcc[4] + (sdmAcc[3] >> 1) - (sdmAcc[5] >> 9);
    sdmSum[5] = sdmAcc[5] + (sdmAcc[3] >> 2);    
    sdmOutSum[1] = sdmSum[3] + sdmSum[4] + sdmSum[5];
    sdmOutSum[1] <<= 1;
    sdmOutSum[1] &= 0x80000000;
    
    sdmSum[6] = sdmAcc[6] + (din >> 1) - sdmOutSum[2];
    sdmSum[7] = sdmAcc[7] + (sdmAcc[6] >> 1) - (sdmAcc[8] >> 9);
    sdmSum[8] = sdmAcc[8] + (sdmAcc[6] >> 2);    
    sdmOutSum[2] = sdmSum[6] + sdmSum[7] + sdmSum[8];
    sdmOutSum[2] <<= 1;
    sdmOutSum[2] &= 0x80000000;

    sdmSum[9] = sdmAcc[9] + (din >> 1) - sdmOutSum[3];
    sdmSum[10] = sdmAcc[10] + (sdmAcc[9] >> 1) - (sdmAcc[11] >> 9);
    sdmSum[11] = sdmAcc[11] + (sdmAcc[9] >> 2);    
    sdmOutSum[3] = sdmSum[9] + sdmSum[10] + sdmSum[11];
    sdmOutSum[3] <<= 1;
    sdmOutSum[3] &= 0x80000000;
    
    sdmSum[12] = sdmAcc[12] + (din >> 1) - sdmOutSum[4];
    sdmSum[13] = sdmAcc[13] + (sdmAcc[12] >> 1) - (sdmAcc[14] >> 9);
    sdmSum[14] = sdmAcc[14] + (sdmAcc[12] >> 2);    
    sdmOutSum[4] = sdmSum[12] + sdmSum[13] + sdmSum[14];
    sdmOutSum[4] <<= 1;
    sdmOutSum[4] &= 0x80000000;

    sdmSum[15] = sdmAcc[15] + (din >> 1) - sdmOutSum[5];
    sdmSum[16] = sdmAcc[16] + (sdmAcc[15] >> 1) - (sdmAcc[17] >> 9);
    sdmSum[17] = sdmAcc[17] + (sdmAcc[15] >> 2);    
    sdmOutSum[5] = sdmSum[15] + sdmSum[16] + sdmSum[17];
    sdmOutSum[5] <<= 1;
    sdmOutSum[5] &= 0x80000000;
    
    sdmSum[18] = sdmAcc[18] + (din >> 1) - sdmOutSum[6];
    sdmSum[19] = sdmAcc[19] + (sdmAcc[18] >> 1) - (sdmAcc[20] >> 9);
    sdmSum[20] = sdmAcc[20] + (sdmAcc[18] >> 2);    
    sdmOutSum[6] = sdmSum[18] + sdmSum[19] + sdmSum[20];
    sdmOutSum[6] <<= 1;
    sdmOutSum[6] &= 0x80000000;

    sdmSum[21] = sdmAcc[21] + (din >> 1) - sdmOutSum[7];
    sdmSum[22] = sdmAcc[22] + (sdmAcc[21] >> 1) - (sdmAcc[23] >> 9);
    sdmSum[23] = sdmAcc[23] + (sdmAcc[21] >> 2);    
    sdmOutSum[7] = sdmSum[21] + sdmSum[22] + sdmSum[23];
    sdmOutSum[7] <<= 1;
    sdmOutSum[7] &= 0x80000000;   
    
    LATBCLR = (0x01 << 5);
}