`include "defines.v"

module spi_gen
(
// input global signals
input clk, clrn, 
// input control signals
input start, bck_inv, ddm, cont, outInv,
input[2:0] bck_num, bck_mode, 
input wck_mode,

// output control
output shift, load,
// output data
output bck, wck, lat
);


// control registers
reg[1:0] bcnt, ibcnt, rbck, rnbck;
reg[3:0] scnt;
reg[6:0] wcnt, cknum;

// output data registers
reg rwck, rlat, rshift, rbusy, rload, rinit, rddm, rrepeat;

wire dualclk = (bck_mode == 0 || bck_mode == 2) ? 1 : 0;
wire wck_rise = (wck_mode == 1) ? (start | rrepeat) : (wcnt == 4);

// output assigments
assign shift = rshift;
assign load = rload;

assign bck = rbck[1] ^ rnbck[1];
assign wck = rwck ^ outInv;
assign lat = rlat ^ outInv;

// async logic
always@( 1 ) begin
	case( bck_num )
	`BCK_NUM_16: cknum = (dualclk) ? 16 : 32;
	`BCK_NUM_18: cknum = (dualclk) ? 18 : 36;
	`BCK_NUM_20: cknum = (dualclk) ? 20 : 40;
	`BCK_NUM_22: cknum = (dualclk) ? 22 : 44;
	`BCK_NUM_24: cknum = (dualclk) ? 24 : 48;
	`BCK_NUM_32: cknum = (dualclk) ? 32 : 64;
	default: cknum = (dualclk) ? 32 : 64;
	endcase
	 
	case( bck_mode )
	0: ibcnt = 0;
	1: ibcnt = 0;
	2: ibcnt = 2;
	3: ibcnt = 1;
	4: ibcnt = 2;
	5: ibcnt = 3;
	default: ibcnt = 2'hx;
	endcase
end

always@( posedge clk or negedge clrn ) begin
	if( !clrn ) begin
		scnt <= 0; bcnt <= 0; wcnt <= 0; rbck <= 0; 		
		rwck <= 0; rlat <= 0; rshift <= 0; rbusy <= 0; rload <= 0; rinit <= 0;
		rddm <= 0; rrepeat <= 0;
	end
	else begin
		rddm <= (start) ? ddm : ( (wcnt == 1 && !bcnt) ? 0 : rddm );
		rrepeat <= (rrepeat) ? 0 : ( (wcnt == 1 && !bcnt) ? rddm : rrepeat );
		rinit <= (scnt == 2) ? 1 : 0;
		
		scnt <= (start | rrepeat) ? 7 : ( (scnt) ? (scnt - 1) : scnt );		
		rwck <= (wck_rise) ? 1 : ( (scnt == 1) ? 0 : rwck );		
		rlat <= (scnt <= 5 && scnt >= 4) ? (~rddm & ddm) : 1;
		
		bcnt <= (rinit) ? ibcnt : ( (!bcnt) ? ( (wcnt | cont) ? ibcnt : bcnt ) : (bcnt - 1) );
		wcnt <= (rinit) ? cknum : ( ((wcnt | cont) && !bcnt) ? (wcnt - 1) : wcnt );

		rbck[1] <= (wcnt | cont) ? ((~wcnt[0]) ^ (~bck_inv)) : 0;
		rbck[0] <= (wcnt | cont) ? (~wcnt[0]) : 0;
		
		rbusy <= (scnt == 2) ? 1 : ( (wcnt == 1 && !bcnt) ? rload : rbusy );
		rshift <= ( rinit || ( (wcnt[0] | dualclk) && !bcnt ) ) ? rbusy : 0;
		
		rload <= (scnt == 2) ? (rddm | ~ddm) : 0;		
	end

end

always@( negedge clk or negedge clrn ) begin
	if( !clrn )
		rnbck <= 0;
	else begin
		rnbck[0] <= rbck[0];
	
		case( bck_mode )
		0: rnbck[1] <= rbck[0];
		2: rnbck[1] <= rnbck[0];
		default: rnbck[1] <= 0;
		endcase
	end
end


endmodule
















