module spi_data
(
// input global signals
input clk, clrn, 
// input control signals
input ob_ntwc, diff, ddm, outInv,
input load1, load2, ena1, ena2,
input[1:0] sd_mode, head_size,

// serial input
input sd,
// input data
input[23:0] d,
input[7:0] head1, head2,

// output data
output sq1, sq2
);


// shift ergisters
reg[15:0] rmsb1, rmsb2;
reg[7:0] rlsb, rhead1, rhead2;

// control registers
reg rlsbch, wlsbena, wsd;

// output registers
reg rq1, rq2, wmux1, wmux2;

// output assigments
assign sq1 = rq1 ^ outInv;
assign sq2 = rq2 ^ outInv;

always@( 1 ) begin
	wlsbena = (rlsbch) ? ena1 : ena2;	
	wsd = (ddm) ? sd : 1'b0;
	
	case( head_size )
	0: begin wmux1 = rmsb1[15]; wmux2 = (rmsb2[15] ^ diff); end
	1: begin wmux1 = rhead1[1]; wmux2 = rhead2[1]; end
	2: begin wmux1 = rhead1[3]; wmux2 = rhead2[3]; end
	3: begin wmux1 = rhead1[7]; wmux2 = rhead2[7]; end
	endcase
end

always@( posedge clk or negedge clrn ) begin
	if( !clrn ) begin
		rlsbch <= 0;
		rlsb <= 0; rmsb1 <= 0; rmsb2 <= 0;		
		rhead1 <= 0; rhead2 <= 0;
		rq1 <= 0; rq2 <= 0;
	end
	else begin
		rlsbch <= (load1) ? 1 : ( (load2) ? 0 : rlsbch );
		
		case( sd_mode )
		`SPI_DATA_DEFAULT: rlsb <= (load1 | load2) ? d[7:0] : ( (wlsbena) ? {rlsb[6:0], wsd} : rlsb );			// default
		`SPI_DATA_16bit: rlsb <= rlsb;																			// 16 bit
		`SPI_DATA_20bit: rlsb <= (load1 | load2) ? d[7:0] : ( (wlsbena) ? {rlsb[6:4], wsd, rlsb[3:0]} : rlsb );	// 20 bit
		`SPI_DATA_24bit: rlsb <= (load1 | load2) ? d[7:0] : ( (wlsbena) ? {rlsb[6:0], wsd} : rlsb );			// 24 bit
		endcase
	
		case( sd_mode )
		default: rmsb1 <= (load1) ? {(d[23] ^ ob_ntwc), d[22:8]} : ( (ena1) ? {rmsb1[14:0], rlsb[7]} : rmsb1 );		// default
		`SPI_DATA_16bit: rmsb1 <= (load1) ? {(d[23] ^ ob_ntwc), d[22:8]} : ( (ena1) ? {rmsb1[14:0], wsd} : rmsb1 );	// 16 bit
		endcase
		
		case( sd_mode )
		default: rmsb2 <= (load2) ? {(d[23] ^ ob_ntwc), d[22:8]} : ( (ena2) ? {rmsb2[14:0], rlsb[7]} : rmsb2 );		// default
		`SPI_DATA_16bit: rmsb2 <= (load2) ? {(d[23] ^ ob_ntwc), d[22:8]} : ( (ena2) ? {rmsb2[14:0], wsd} : rmsb2 );	// 16 bit
		endcase

		rhead1 <= (load1) ? head1 : ( (ena1) ? {rhead1[6:0], rmsb1[15]} : rhead1 );
		rhead2 <= (load2) ? head2 : ( (ena2) ? {rhead2[6:0], (rmsb2[15] ^ diff)} : rhead2 );
		
		if( ena1 ) rq1 <= wmux1;
		if( ena2 ) rq2 <= wmux2;
	end
end




endmodule
















