library verilog;
use verilog.vl_types.all;
entity data_ram is
    generic(
        W               : integer := 32
    );
    port(
        clk             : in     vl_logic;
        clrn            : in     vl_logic;
        iread           : in     vl_logic;
        istart          : in     vl_logic;
        inmux           : in     vl_logic;
        write           : in     vl_logic;
        radr            : in     vl_logic_vector(8 downto 0);
        oadr            : in     vl_logic_vector(8 downto 0);
        wadr            : in     vl_logic_vector(8 downto 0);
        dleft           : in     vl_logic_vector;
        dright          : in     vl_logic_vector;
        mleft           : in     vl_logic_vector;
        mright          : in     vl_logic_vector;
        qleft           : out    vl_logic_vector;
        qright          : out    vl_logic_vector;
        qread           : out    vl_logic;
        qstart          : out    vl_logic
    );
    attribute mti_svvh_generic_type : integer;
    attribute mti_svvh_generic_type of W : constant is 1;
end data_ram;
