// 5-th order DSM from SONY. Nominal FS modulation index is 0.5.

module sdmL (
input wire mck, clrn,
input wire signed [IWL-1:0] q_left,
output reg dsdl
);

parameter IWL = 24;
parameter ADDP = 2;
reg signed [IWL+ADDP-1:0] S0ACC, S1ACC, S2ACC, S3ACC, S4ACC;
wire signed [IWL+ADDP-1:0] S0, S1, S2, S3, S4;
wire signed [IWL+ADDP:0] SUMALL;

initial
begin
S0ACC <= 0;
S1ACC <= 0;
S2ACC <= 0;
S3ACC <= 0;
S4ACC <= 0;
dsdl <= 0;
end

assign S0 = q_left + S0ACC + (dsdl? (-(2**IWL-1)):(2**IWL-1));
assign S1 = ((S0 + 1) >>> 1) + S1ACC - ((S2ACC + 256) >>> 9);
assign S2 = ((S1 + 2) >>> 2) + S2ACC;
assign S3 = ((S2 + 4) >>> 3) + S3ACC - ((S4ACC + 16) >>> 5);
assign S4 = ((S3 + 8) >>> 4) + S4ACC;
assign SUMALL = S0 + S1 + S2 + S3 + S4;

always @ (posedge mck or posedge clrn)
begin
	if (clrn)
	begin
	dsdl <= 1'b0;
	S0ACC <= 0;
	S1ACC <= 0;
	S2ACC <= 0;
	S3ACC <= 0;
	S4ACC <= 0;
	end
	else
	begin
	dsdl <= !SUMALL[IWL+ADDP];
	S0ACC <= S0;
	S1ACC <= S1;
	S2ACC <= S2;
	S3ACC <= S3;
	S4ACC <= S4;
	end
end
endmodule