//-----------------------------------
//
//-----------------------------------
`timescale  1ns/1ns
//
module pwm16
    (
        input       mcko,
        input       nd_i,
        input [2:0] x_i,
        output[1:0] y_o
    );
    //==========================
    function[15:0] f_pwm(input[2:0] x);
        case(x)
        0: f_pwm = 'h0000;
        1: f_pwm = 'h0808;
        2: f_pwm = 'h180c;
        3: f_pwm = 'h1c1c;
        4: f_pwm = 'h3c1e;
        5: f_pwm = 'h3e3e;
        6: f_pwm = 'h7e3f;
        7: f_pwm = 'h7f7f;
        endcase
    endfunction
    //==========================
    reg [15:0] r0=0,r1=0;
    always @(posedge mcko)
    begin
        r1 <= #1 nd_i? f_pwm(  x_i^4 ): r1<<1;
        r0 <= #1 nd_i? f_pwm(-(x_i^4)): r0<<1;
    end
    //
    assign y_o = {r1[15],r0[15]};
    //
endmodule
/* EOF pwm16.v */
