//==================================
//
//==================================
`timescale  1ns/1ns

module mash3 #(parameter DW=24)
    (
        input  mcko,
        input  nd_i,
        input  signed[7   :0] d_i,  // dithering
        input  signed[DW-1:0] x_i,  // input data
        output [1:0] y_o,           // output data
        output nd_o
    );
    //--------------------
    localparam AW=DW+4,NQ=2,OW=NQ+1,MW=DW-1;
    //--------------------
    function signed[OW-1:0] f_qn(input signed[AW-1:0] x);
        reg signed[OW:0] u;
        begin
            u = x+2**(MW-1)>>>MW;       // rounding
            f_qn= NQ<u?NQ:(-NQ>u?-NQ:u);// (-2..+2)
        end
    endfunction
    //-------------
    reg [5:0] sr = 0;
    wire[6:0] s = {sr, nd_i};
    always @(posedge mcko)
        sr <= #1 s;
    //--------------------
    reg  signed[DW-1:0] x=0;
    reg  signed[AW-1:0] r1=0,r2=0;
    reg  signed[AW-1:0] S0=0,S1=0,S2=0;
    //
    reg  signed[OW-1:0] y=0;
    reg q2=0;
    wire signed[1   :0] z2= q2^r2[AW-1]?{r2[AW-1],q2|r2[AW-1]}:0;
    //--------------------
    always @(posedge mcko)
    case(1)
    s[0]: begin
            x  <= #1 x_i;           // r0 = x_i
            r1 <= #1 S0+(d_i<<MW-8);// r1 = S0+dith
            r2 <= #1 S2+(S1<<1);    // r2 = S2+2*S1
          end
    s[1]: begin
            S2 <= #1 S2+S1;         // S2 += S1
            r1 <= #1 r1+(S1>>>0);   // r1 += alpha*S1
          end
    s[2]: begin
            y  <= #1 f_qn(r1);      // f_qn(S0+S1+d_i) [-2..+2]
          end   // --- q1 ---
    s[3]: begin
            r1 <= #1 S0-(y<<MW);    // r1 = e1=(S0-q1)
          end
    s[4]: begin
            S0 <= #1 x+r1;          // S0 = x_i+e1
            r2 <= #1 r2+r1;
          end   // --- q2 ---
    s[5]: begin
            y  <= #1 y+z2;          // y[n] = q1+(q2[n]-q2[n-1])/2
            q2 <= #1 r2[AW-1];      // q2[n] = signum(r2)
            r1 <= #1 r1-((r2[AW-1]?-1:1)<<MW-1); // r1 = e1-(q2*2**mw)/2
          end
    s[6]: begin
            S1 <= #1 S1+r1;
          end
    endcase
    //
    assign nd_o = s[6];
    pwm16
    PWM
    (
        .mcko    (mcko    ),
        .nd_i   (nd_o   ),
        .x_i    (y      ),
        .y_o    (y_o    )
    );
endmodule
/* EOF mash3.v */
