// for Fir - Lenth1 = coef num; Lenth2 = Lenth1 - 2.

module data_adr
(
// input global signals
input clk, clrn, bypass,
input[1:0] sync,

// input initialisation parameters
input[6:0] curr_pos, num_repeat, length_row1, length_row2,
input[2:0] curr_stage,

// output control siggnals
output next_stage,
output[2:0] data_stage,	// - flag end of MAC cicle
output data_read,
output data_sync,

// output coefficient generator control signals
output[2:0] coef_stage,
output coef_init,

// output RAM data adress
output[8:0] data_adr
);

// adress generate core registers
reg[6:0] rcurr, rptcnt, adrcnt, rlen1, rlen2;
reg[6:0] pos, sumcnt, invcnt;
reg[2:0] adrMsb;
reg[5:0] adrLsb;

// support registers to generate control signals
reg[2:0] stage0, stage1;
reg[2:0] cstage0, cstage1;
reg[2:0] rread;
reg[1:0] rcinit;
reg ena, next, adrsync, halfband;

// csync schematics and connections
wire[6:0] sum = pos + sumcnt;
wire row = rptcnt[0];

// data RAM output signals
assign data_adr = {adrMsb, adrLsb};
assign data_stage = stage1;
assign data_read = rread[2];
assign data_sync = adrsync;

// next stage output signal
assign next_stage = next;

// coef ROM output sianals
assign coef_stage = cstage1;
assign coef_init = rcinit[1];


/*
	Adress generation for RAM data
*/
always@(posedge clk or negedge clrn) begin
	if( clrn == 0 ) begin
		// negative global reset - set all registers to zero
		rcurr <= 0; rptcnt <= 0; adrcnt <= 0; rlen1 <= 0; rlen2 <= 0;
		pos <= 0; sumcnt <= 0; invcnt <= 0;
		adrLsb <= 0; adrMsb <= 0;
		stage0 <= 0; stage1 <= 0; cstage0 <= 0; cstage1 <= 0;
		rread[0] <= 0; rread[1] <= 0; rread[2] <= 0;
		rcinit <= 0; ena <= 0; adrsync <= 0; next <= 0; halfband <= 0;
	end
	else begin // clrn scope begin	
		ena <= (sync == 0 || sync == 1) ? 1 : 0;

		if( ena ) begin // enable scope begin
		
			if( adrcnt >= rlen1 ) begin
				adrcnt <= 0; // adress counter reset
				
				if( rptcnt == 0 ) begin
					// reload initialisation parameters
					rcurr <= curr_pos - (length_row2 >> 1);
					rptcnt <= -num_repeat;
					rlen1 <= length_row1;
					rlen2 <= length_row2;
					stage0 <= curr_stage;
					halfband <= (length_row1 == 1) ? 1 : 0;	// optimisation for half-band mode
				end
				else begin
					rptcnt <= rptcnt + 1;
					rlen1 <= rlen2;
					rlen2 <= rlen1;
				end
			end
			else begin
				adrcnt <= adrcnt + 1; // data adress counter increment
			end
			
			stage1 <= (bypass && !row) ? 0 : ( (adrcnt >= rlen1) ? stage0 : 0 );
			cstage0 <= stage0;
			cstage1 <= cstage0;
			
			pos <= rcurr + {rptcnt[6], rptcnt[6:1]};
			invcnt <= ~(adrcnt >> 1) + row;
			adrLsb <= sum[5:0];
			
			case( cstage0 )
			1: adrMsb <= {2'h0, sum[6]};
			2: adrMsb <= 3'h2;
			3: adrMsb <= 3'h3;
			4: adrMsb <= 3'h4;
			5: adrMsb <= 3'h5;
			default: adrMsb <= 3'hx;
			endcase
			
			sumcnt <= (adrcnt[0] == 0) ? (adrcnt >> 1) : invcnt;

			rread[0] <= (bypass && !row) ? 0 : ( (adrcnt == 1) ? ((~row) | halfband) : 1 );
			rread[1] <= stage0[0] | stage0[1] | stage0[2];
			rread[2] <= rread[1] & rread[0];
			
			rcinit[0] <= (adrcnt == 0 && stage0) ? row : 0;
			rcinit[1] <= rcinit[0];
			
			adrsync <= (bypass && !row) ? 0 : adrcnt[0];
		end	// enable scope end
		else begin
			rread[2] <= 0;
			rcinit[1] <= 0;
			adrsync <= 0;
		end
		
		next <= (sync == 0 && adrcnt >= rlen1 && rptcnt == 0) ? 1 : 0;			
	end // clrn scope end

end





endmodule
