`include "defines.v"
`include "rom_coef_control.v"

module coef_control
(
// input global sync signals
input clk, clrn,
// input config
input mck_mode, lp_mode,
input[1:0] ovs_max,
input[2:0] fs_in,

// output coef settings
output [6:0] st1_len1, st2_len1, st3_len1, st4_len1, st5_len1,
output [6:0] st1_len2, st2_len2, st3_len2, st4_len2, st5_len2,
// output coef adr
output [9:0] st1_adr, st2_adr, st3_adr, st4_adr, st5_adr
);

reg[6:0] rst1_len1, rst1_len2;
reg[9:0] rst1_adr;
wire[2:0] wstage1;

assign st1_len1 = rst1_len1;
assign st1_len2 = rst1_len2;

assign st2_len1 = `STAGE_2_LEN_1_HB;
assign st2_len2 = `STAGE_2_LEN_2_HB;

assign st3_len1 = `STAGE_3_LEN_1_HB;
assign st3_len2 = `STAGE_3_LEN_2_HB;

assign st4_len1 = `STAGE_4_LEN_1_HB;
assign st4_len2 = `STAGE_4_LEN_2_HB;

assign st5_len1 = (mck_mode || lp_mode) ? `STAGE_5_LEN_1_HB : `STAGE_5_LEN_1_HB_HR;
assign st5_len2 = (mck_mode || lp_mode) ? `STAGE_5_LEN_2_HB : `STAGE_5_LEN_2_HB_HR;

// coef output adr asssigments
assign st1_adr = rst1_adr;
assign st2_adr = `STAGE_2_COEF_ADR_HB;
assign st3_adr = `STAGE_3_COEF_ADR_HB;
assign st4_adr = `STAGE_4_COEF_ADR_HB;
assign st5_adr = (mck_mode || lp_mode) ? `STAGE_5_COEF_ADR_HB : `STAGE_5_COEF_ADR_HB_HR;

always@( wstage1 )
	case( wstage1 )
	`FIRST_STG_BYPASS:	begin rst1_len1 = `STAGE_BYPASS_LEN_1;		rst1_len2 = `STAGE_BYPASS_LEN_2;	rst1_adr = `STAGE_BYPASS_ADR;			end
	`FIRST_STG_HR:		begin rst1_len1 = `STAGE_1_LEN_1_HR;		rst1_len2 = `STAGE_1_LEN_2_HR;		rst1_adr = `STAGE_1_COEF_ADR_HR;		end
	`FIRST_STG_HB:		begin rst1_len1 = `STAGE_1_LEN_1_HB;		rst1_len2 = `STAGE_1_LEN_2_HB;		rst1_adr = `STAGE_1_COEF_ADR_HB;		end
	`FIRST_STG_HB_LP:	begin rst1_len1 = `STAGE_1_LEN_1_HB_LP;		rst1_len2 = `STAGE_1_LEN_2_HB_LP;	rst1_adr = `STAGE_1_COEF_ADR_HB_LP;		end
	`FIRST_STG_HB_VLP:	begin rst1_len1 = `STAGE_1_LEN_1_HB_VLP;	rst1_len2 = `STAGE_1_LEN_2_HB_VLP;	rst1_adr = `STAGE_1_COEF_ADR_HB_VLP;	end
	default:			begin rst1_len1 = `STAGE_BYPASS_LEN_1;		rst1_len2 = `STAGE_BYPASS_LEN_2;	rst1_adr = `STAGE_BYPASS_ADR;			end
	endcase

rom_coef_control __rom_coef_control(
	// input config
	.adr( {mck_mode, lp_mode, ovs_max[1:0], fs_in[2:0]} ),

	.st1( wstage1 )
);


endmodule










