module coef_adr
(
// input global signals
input clk, clrn, init, dsync,

// input initialisation parameters
input[2:0] stage_num,

// input adresses to varios stages
input[9:0] adr_st1, adr_st2, adr_st3, adr_st4, adr_st5,

// output ROM coefficients adress
output[9:0] coef_adr
);

// support registers to generate control signals
reg[9:0] offsetcnt, sumadr;
reg[9:0] stageadr;
reg[1:0] syncnt;

// output adress value
assign coef_adr = sumadr;

/*
	Adress generation for ROM coefficients
*/
always@(posedge clk or negedge clrn) begin
	if( clrn == 0 ) begin 
		// negative global reset - set all registers to zero
		offsetcnt <= 0; stageadr <= 0; sumadr <= 0; syncnt <= 0;
	end
	else begin // clrn scope begin	
		syncnt <= (dsync) ? 3 : ( (syncnt) ? (syncnt - 1) : syncnt );
		offsetcnt <= (init || (syncnt == 1 && !dsync)) ? 0 : ( (syncnt) ? (offsetcnt + 1) : offsetcnt );

		if( init ) begin
			case( stage_num )
			1: stageadr <= adr_st1;
			2: stageadr <= adr_st2;
			3: stageadr <= adr_st3;
			4: stageadr <= adr_st4;
			5: stageadr <= adr_st5;
			default: stageadr <= 9'hxxx;
			endcase
		end
		else if( syncnt == 1 && !dsync )
			stageadr <= 9'h1ff;
		
		sumadr <= stageadr + offsetcnt;
	end // clrn scope end
end



endmodule














