// 5-th order DSM from SONY. Nominal FS modulation index is 0.5.
`define SDM5_POLYNOM	(22'h270911)

module SONY5DSM
#(parameter IWL = 20,ADDP = 2)
(
input wire CLK, RESET,
input wire signed [IWL-1:0] DI,
output reg PDM);

reg signed [21:0] LFSR;
wire signed [21:0] DITH = LFSR >>> (25 - IWL);

reg signed [IWL+ADDP-1:0] S0ACC, S1ACC, S2ACC, S3ACC, S4ACC;
wire signed [IWL+ADDP-1:0] S0, S1, S2, S3, S4;
wire signed [IWL+ADDP:0] SUMALL;

initial
begin
LFSR <= `SDM5_POLYNOM;
S0ACC <= 0;
S1ACC <= 0;
S2ACC <= 0;
S3ACC <= 0;
S4ACC <= 0;
PDM <= 0;
end

assign S0 = DI + S0ACC + (PDM ? (-(2**IWL-1)) : (2**IWL-1));
assign S1 = ((S0 + 1) >>> 1) + S1ACC - ((S2ACC + 256) >>> 9);
assign S2 = ((S1 + 2) >>> 2) + S2ACC;
assign S3 = ((S2 + 4) >>> 3) + S3ACC - ((S4ACC + 16) >>> 5);
assign S4 = ((S3 + 8) >>> 4) + S4ACC;
assign SUMALL = S0 + S1 + S2 + S3 + S4 + DITH;

always @ (posedge CLK or posedge RESET)
begin
	if (RESET)
	begin
	LFSR <= `SDM5_POLYNOM;
	PDM <= 1'b0;
	S0ACC <= 0;
	S1ACC <= 0;
	S2ACC <= 0;
	S3ACC <= 0;
	S4ACC <= 0;
	end
	else
	begin
	LFSR <= (LFSR >> 1) ^ (`SDM5_POLYNOM * LFSR[0]);
	PDM <= !SUMALL[IWL+ADDP];
	S0ACC <= S0;
	S1ACC <= S1;
	S2ACC <= S2;
	S3ACC <= S3;
	S4ACC <= S4;
	end
end


endmodule



