`include "defines.v"
`include "pll.v"
`include "SAI_input.v"
`include "DF1_FIR_CORE.v"
`include "SAI_output.v"
//`include "sdmL.v"
//`include "sdmR.v"
`include "SONY5DSM.v"
`define	SDM_OVS_x64			3
`define	SDM_OVS_x128		2
`define	SDM_OVS_x256		1
`define	SDM_OVS_x512		0
// Set SDM oversampling
`define SDM_OVS				`SDM_OVS_x128

	
module DF1
(
// global clock/reset inputs
input clki, 				// global master-clock input
input bck_inv, 			// 1 - force bck inversion
input outInv,			// 1 - invert serial outputs both channels: dat, wck and lutch.
input dg_inv,			// deglitcher signal invertion
input oscsel,			// osc clock domen select: 0 - osc1ena, 1 - osc2ena


// ------------------------  Config ports -------------------------------------------------------------------------
/*
input clrn, 			// global nReset input (active low)*/
/*
// clock config
input mck_mode,			// input clock multiplicity: 0 - 1024Fs, 1 - 768Fs
input mck_div,			// otput mck divider: 0 - clk/1, 1 - clk/2*/
/*
// FIR filter config
input lp_mode,			// 1 - enable low power mode
input[1:0] att,			// attenuation input signal: 0 - 0db, 1 - 1db, 2 - 2db, 3 - 3db
input[1:0] ovs_max, 	// max oversampling 0..3 - x4..x32*/
/*
// input config
input[1:0] format, 		// 0 - I2S, 1 - LJ, 2 - RJ24, 3 - RJ16
input[1:0] frame,		// input frame lenth: 0 (or 3) - 64bit, 1 - 48bit, 2 - 32bit
input mute,				// soft mute input signal (active high)*/
/*
// output data format config
input ob_ntwc, 			// 1 - offset binary, 0 - 2's complement*/
/*
input[2:0] d_width, 	// data lenth 0..4 - 16bit..24 bit (2bit step), 5 - 32bit, 6..7 - bck_continue mode (24bit - right justified)
input[2:0] d_speed, 	// data rate 0..5 - clk/1, clk/2, clk/3, clk/4, clk/6, clk/8
input[1:0] spi_dsize,	// SPI data field lenth 0 - = d_width, 1 - 16bit, 2 - 20bit, 3 - 24bit
input[2:0] spi_mode,	// 0 - diff, 1 - diff serial, 2 - conv, 3 - conv serial, 4 - channels serial
input[2:0] head_mode,	// 0 - no header, 1 - DAC8812 head, 2 - AD5791 head, 3 - AD5063 head, 4 - DAC11001 head, 5 - LTC1592 head, 6 - LTC2752 head, 7 - reserved*/
/*
input outZ,				// 1 - force spi output both channals (dat, bck and wck) to Z-state.*/
/*
// deglitcher config
input dg_pp,			// deglitcher pipeline mode
input dg_off,			// logic 1 - turn deglitching sirciut to always sample state (off state)
input[1:0] dgh_mode, 	// deglitcher rise front mode
input[1:0] dgl_mode,	// deglitcher fall front mode if spi_dsize == 0 then (0 - rise wck, 1 - fall wck, 2 - pcm1704 mode, 3 - pcm1702 mode), else (0 - rise wck, 1 - fall latch)*/
// ----------------------------------------------------------------------------------------------------------------


// led indicator outputs (active low)
output[2:0] ovs_ind,
output clipping,

// SAI input data signals
input sai_dat, sai_sck, sai_lrc,

// output SPI (or PCM) data signals
//output dat1_left, dat1_right, bck1, wck1, ltch1,
//output dat2_left, dat2_right, bck2, wck2, ltch2,
output dg,dsdL,dsdR,dsdCk,

// clock control outputs
output osc1ena, osc2ena	// oscillator controls					
);


// ------------------------  Config ports -------------------------------------------------------------------------
wire clrn = 1;

// clock config
wire mck_mode = 0;			// input clock multiplicity: 0 - 1024Fs, 1 - 768Fs
wire mck_div = 1;			// otput mck divider: 0 - clk/1, 1 - clk/2*/

// FIR filter config
wire lp_mode = 0;			// 1 - enable low power mode
wire[1:0] att = 0;			// attenuation input signal: 0 - 0db, 1 - 1db, 2 - 2db, 3 - 3db
wire[1:0] ovs_max = 3; 	// max oversampling 0..3 - x4..x32*/

// input config
wire[1:0] format = 0; 		// 0 - I2S, 1 - LJ, 2 - RJ24, 3 - RJ16
wire[1:0] frame = 0;		// input frame lenth: 0 (or 3) - 64bit, 1 - 48bit, 2 - 32bit
wire mute = 0;				// soft mute input signal (active high)*/

// output data format config
wire ob_ntwc = 0; 			// 1 - offset binary, 0 - 2's complement*/

wire[2:0] d_width = 4; 	// data lenth 0..4 - 16bit..24 bit (2bit step), 5 - 32bit, 6..7 - bck_continue mode (24bit - right justified)
wire[2:0] d_speed = 1; 	// data rate 0..5 - clk/1, clk/2, clk/3, clk/4, clk/6, clk/8
wire[1:0] spi_dsize = 3;	// SPI data field lenth 0 - = d_width, 1 - 16bit, 2 - 20bit, 3 - 24bit
wire[2:0] spi_mode = 0;	// 0 - diff, 1 - diff serial, 2 - conv, 3 - conv serial, 4 - channels serial
wire[2:0] head_mode = 0;	// 0 - no header, 1 - DAC8812 head, 2 - AD5791 head, 3 - AD5063 head, 4 - DAC11001 head, 5 - LTC1592 head, 6 - LTC2752 head, 7 - reserved*/

wire outZ = 0;				// 1 - force spi output both channals (dat, bck and wck) to Z-state.*/

// deglitcher config
wire dg_pp = 0;			// deglitcher pipeline mode
wire dg_off = 0;			// logic 1 - turn deglitching sirciut to always sample state (off state)
wire[1:0] dgh_mode = 1; 	// deglitcher rise front mode
wire[1:0] dgl_mode = 3;	// deglitcher fall front mode if spi_dsize == 0 then (0 - rise wck, 1 - fall wck, 2 - pcm1704 mode, 3 - pcm1702 mode), else (0 - rise wck, 1 - fall latch)
// ----------------------------------------------------------------------------------------------------------------


// control registers
reg[16:0] rclip;

// SAI_input outputs
wire sai_in_rdy;
wire signed[`BUS_WIDTH-1:0] sai_d_left, sai_d_right;

// fir_lp_stereo_27bit outputs
wire signed[23:0] fir_out_left, fir_out_right;
wire[2:0] wfs_in;
wire wclip, wbypass;

// SAI_Output outputs
reg sai_out_load;

// output assigments
assign osc1ena = (~oscsel);
assign osc2ena = oscsel;
assign ovs_ind = (wbypass) ? 0 : (~wfs_in);
assign clipping = rclip[16];

wire sclip = ~rclip[16] & sai_in_rdy;

wire wclk;

pll _pll(
	.inclk0(clki),
	.c0(wclk)
	);


// digital clipping nidication
always@( posedge wclk or negedge wclip ) begin
	rclip <= (!wclip) ? 0 : (rclip + sclip);
end

SAI_input __sai_input(
	// global clock/reset inputs
	.clk( wclk ), .clrn( clrn ),
	// control inputs
	.mute( mute ),
	.format( format ), .frame( frame ), .att( att ),
	// serial data input
	.sai_dat( sai_dat ), .sai_sck( sai_sck ), .sai_lrc( sai_lrc ),

	// parallel data output
	.q_left( sai_d_left ), .q_right( sai_d_right ),
	.ready( sai_in_rdy )
);

DF1_FIR_CORE __fir(
	// global clock/reset inputs
	.clk( wclk ), .clrn( clrn ), .mck_mode( mck_mode ), .mck_div( mck_div ),
	// setting inputs
	.sai_lrc( sai_lrc ), .lp_mode( lp_mode ), .dithen( 1'b1 ), .shpen( 1'b1 ),
	.ovs_max( ovs_max ), .att( att ),
	.d_width( d_width ),
	// control inputs
	.in_ready( sai_in_rdy ), .out_load( sai_out_load ),
	// input data
	.d_left( sai_d_left ), .d_right( sai_d_right ),

	// output data
	.q_left( fir_out_left ), .q_right( fir_out_right ),
	.fs_in( wfs_in ),
	.mcko( mcko ), .clipn( wclip ), .bypass( wbypass )
);

// output signals assigments DSD
assign dsdCk = scnt[`SDM_OVS];
// system counter
reg[4:0] scnt;
reg signed[19:0] rdsdinL, rdsdinR;

wire sdmclk = ~scnt[`SDM_OVS];

// output signals assigments DSD
assign dsdCk = scnt[`SDM_OVS];


always@ (posedge clki or negedge clrn) begin
	if (!clrn) begin
		scnt <= 0;
		sai_out_load <= 0;
		rdsdinL <= 0; rdsdinR <= 0;
	end
	else begin
		scnt <= scnt + 1;
		sai_out_load <= (!scnt) ? 1 : 0;
		rdsdinL <= (!scnt) ? (fir_out_left >>> 4) : rdsdinL;
		rdsdinR <= (!scnt) ? (fir_out_right >>> 4) : rdsdinR;
	end
end


//sdmL _sdmL(
//	.mck(sdmclk),
//	.q_left( rdsdinL ),
//	.dsdl(dsdl)
////	);

//sdmR _sdmR(
//	.mck(sdmclk),
//	.q_right( rdsdinR  ),
//	.dsdr(dsdr)
//	);

SONY5DSM #( .IWL(20), .ADDP(3) ) _sdm_left (
	.CLK( sdmclk ), .RESET( ~clrn ),
	.DI( rdsdinL ),
	.PDM( dsdL )
);

SONY5DSM #( .IWL(20), .ADDP(3) ) _sdm_right (
	.CLK( sdmclk ), .RESET( ~clrn ),
	.DI( rdsdinR ),
	.PDM( dsdR )
);

endmodule







