`include "defines.v"
`include "SAI_input.v"
`include "DF1_FIR_CORE.v"
`include "SAI_output.v"
`include "SONY_SDM_5.v"

`define	SDM_OVS_x64			3
`define	SDM_OVS_x128		2
`define	SDM_OVS_x256		1
`define	SDM_OVS_x512		0
// Set SDM oversampling
`define SDM_OVS				`SDM_OVS_x64

module pcm1792
(
// global clock inputs
input clk, clrn,

// I2S DAC input
input bcki, dati, lrci,
// audio data to DSD DAC
output dsdL, sdsR, dsdCk
);

// SAI_input outputs
wire sai_in_rdy;
wire signed[`BUS_WIDTH-1:0] sai_d_left, sai_d_right;

// fir_lp_stereo_24bit outputs
wire signed[23:0] fir_out_left, fir_out_right;

// system counter
reg[4:0] scnt;
reg sai_out_load;
reg signed[19:0] rdsdinL, rdsdinR;

wire sdmclk = ~scnt[`SDM_OVS];

// output signals assigments DSD
assign dsdCk = scnt[`SDM_OVS];


always@ (posedge clk or negedge clrn) begin
	if (!clrn) begin
		scnt <= 0;
		sai_out_load <= 0;
		rdsdinL <= 0; rdsdinR <= 0;
	end
	else begin
		scnt <= scnt + 1;
		sai_out_load <= (!scnt) ? 1 : 0;
		rdsdinL <= (!scnt) ? (fir_out_left >>> 4) : rdsdinL;
		rdsdinR <= (!scnt) ? (fir_out_right >>> 4) : rdsdinR;
	end
end


SAI_input __sai_input(
	// global clock/reset inputs
	.clk( clk ), .clrn( clrn ),
	// control inputs
	.mute( 0 ),
	.format( 1 ), // 0 - I2S, 1 - LJ
	.frame( 0 ), .att( 0 ),
	// serial data input
	.sai_dat( dati ), .sai_sck( bcki ), .sai_lrc( lrci ),

	// parallel data output
	.q_left( sai_d_left ), .q_right( sai_d_right ),
	.ready( sai_in_rdy )
);

DF1_FIR_CORE __fir(
	// global clock/reset inputs
	.clk( clk ), .clrn( clrn ), .mck_mode( 0 ), .mck_div( 0 ),
	// setting inputs
	.sai_lrc( lrci ), .lp_mode( 0 ), .dithen( 1 ), .shpen( 0 ),
	.ovs_max( 3 ), 	// max oversampling 0..3 - x4..x32
	.att( 0 ),
	.d_width( 2 ), 	// data lenth 0..4 - 16bit..24 bit (2bit step),
	// control inputs
	.in_ready( sai_in_rdy ), .out_load( sai_out_load ),
	// input data
	.d_left( sai_d_left ), .d_right( sai_d_right ),

	// output data
	.q_left( fir_out_left ), .q_right( fir_out_right ),
	.fs_in(  ),
	.mcko(  ), .clipn(  ), .bypass(  )
);

SONY5DSM #( .IWL(20), .ADDP(3) ) _sdm_left (
	.CLK( sdmclk ), .RESET( ~clrn ),
	.DI( rdsdinL ),
	.PDM( dsdL )
);

SONY5DSM #( .IWL(20), .ADDP(3) ) _sdm_right (
	.CLK( sdmclk ), .RESET( ~clrn ),
	.DI( rdsdinR ),
	.PDM( dsdR )
);

endmodule


