`include "defines.v"
/***********************************************************************************************
	Max number multiplications for Fmck = 1024Fs
	in one input sampling period
	case( fs_in ) 
	48k: 1024/3 - 1 = 340
	96k: 512/3 - 1 = 169
	192k: 256/3 - 1 = 84
	384k: 128/3 - 1 = 41
	768k: 64/3 - 1 = 20
	
	mult num mck - 1024, high ripple mode ------------------------------------------------------	
	*in 48k (mult num max - 340)
	out x4, mult num = 64+63 + 2*(1+8) = 145									FIRST_STG_HR
	out x8, mult num = 64+63 + 2*(1+8) + 4*(1+4) = 165							FIRST_STG_HR
	out x16, mult num = 64+63 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 197				FIRST_STG_HR
	out x32, mult num = 64+63 + 2*(1+8) + 4*(1+4) + 8*(1+3) + 16*(1+3) = 261	FIRST_STG_HR
	
	*in 96k (mult num max - 169)
	out x4, mult num = 64+63 = 127												FIRST_STG_HR
	out x8, mult num = 64+63 + 2*(1+8) = 145									FIRST_STG_HR
	out x16, mult num = 64+63 + 2*(1+8) + 4*(1+4) = 165							FIRST_STG_HR
	out x32, mult num = 1+44 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 115				FIRST_STG_HB
	
	*in 192k (mult num max - 84)
	out x4, bypass
	out x8, mult num = 1+44 = 45												FIRST_STG_HB
	out x16, mult num = 1+44 + 2*(1+8) = 63										FIRST_STG_HB
	out x32, mult num = 1+44 + 2*(1+8) + 4*(1+4) = 83							FIRST_STG_HB
	
	*in 384k (mult num max - 41)
	out x4, bypass
	out x8, bypass
	out x16, mult num = 1+20 = 21												FIRST_STG_HB_LP
	out x32, mult num = 1+20 + 2*(1+8) = 39										FIRST_STG_HB_LP
	
	*in 768k (mult num max - 20)
	out x4, bypass
	out x8, bypass
	out x16, bypass
	out x32, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	--------------------------------------------------------------------------------------------

	mult num mck - 1024, low power mode --------------------------------------------------------	
	*in 48k (mult num max - 340)
	out x4, mult num = 1+44 + 2*(1+8) = 63										FIRST_STG_HB
	out x8, mult num = 1+44 + 2*(1+8) + 4*(1+4) = 83							FIRST_STG_HB
	out x16, mult num = 1+44 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 115				FIRST_STG_HB
	out x32, mult num = 1+44 + 2*(1+8) + 4*(1+4) + 8*(1+3) + 16*(1+2) = 163		FIRST_STG_HB
	
	*in 96k (mult num max - 169)
	out x4, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	out x8, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	out x16, mult num = 1+12 + 2*(1+8) + 4*(1+4) = 51							FIRST_STG_HB_VLP
	out x32, mult num = 1+12 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 83					FIRST_STG_HB_VLP
	
	*in 192k (mult num max - 84)
	out x4, bypass
	out x8, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	out x16, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	out x32, mult num = 1+12 + 2*(1+8) + 4*(1+4) = 51							FIRST_STG_HB_VLP
	
	*in 384k (mult num max - 41)
	out x4, bypass
	out x8, bypass
	out x16, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	out x32, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	
	*in 768k (mult num max - 20)
	out x4, bypass
	out x8, bypass
	out x16, bypass
	out x32, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	--------------------------------------------------------------------------------------------
		
************************************************************************************************
	Max number multiplications for Fmck = 768Fs
	in one input sampling period
	case( fs_in ) 
	48k: 768/3 = 256
	96k: 384/3 = 128
	192k: 192/3 = 64
	384k: 96/3 = 32
	768k: 48/3 = 16
	
	mult num mck - 768, high ripple mode -------------------------------------------------------	
	*in 48k (mult num max - 256)
	out x4, mult num = 64+63 + 2*(1+8) = 145									FIRST_STG_HR
	out x8, mult num = 64+63 + 2*(1+8) + 4*(1+4) = 165							FIRST_STG_HR
	out x16, mult num = 64+63 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 197				FIRST_STG_HR
	out x32, mult num = 64+63 + 2*(1+8) + 4*(1+4) + 8*(1+3) + 16*(1+2) = 245	FIRST_STG_HR
	
	*in 96k (mult num max - 128)
	out x4, mult num = 64+63 = 127												FIRST_STG_HR
	out x8, mult num = 1+44 + 2*(1+8) = 63										FIRST_STG_HB
	out x16, mult num = 1+44 + 2*(1+8) + 4*(1+4) = 83							FIRST_STG_HB
	out x32, mult num = 1+44 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 115				FIRST_STG_HB
	
	*in 192k (mult num max - 64)
	out x4, bypass
	out x8, mult num = 1+44 = 45												FIRST_STG_HB
	out x16, mult num = 1+44 + 2*(1+8) = 63										FIRST_STG_HB
	out x32, mult num = 1+20 + 2*(1+8) + 4*(1+4) = 59							FIRST_STG_HB_LP
	
	*in 384k (mult num max - 32)
	out x4, bypass
	out x8, bypass
	out x16, mult num = 1+20 = 21												FIRST_STG_HB_LP
	out x32, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	
	*in 768k (mult num max - 16)
	out x4, bypass
	out x8, bypass
	out x16, bypass
	out x32, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	--------------------------------------------------------------------------------------------
	
	mult num mck - 768, low power mode ---------------------------------------------------------	
	*in 48k (mult num max - 256)
	out x4, mult num = 1+44 + 2*(1+8) = 63										FIRST_STG_HB
	out x8, mult num = 1+44 + 2*(1+8) + 4*(1+4) = 83							FIRST_STG_HB
	out x16, mult num = 1+44 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 115				FIRST_STG_HB
	out x32, mult num = 1+44 + 2*(1+8) + 4*(1+4) + 8*(1+3) + 16*(1+2) = 163		FIRST_STG_HB
	
	*in 96k (mult num max - 128)
	out x4, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	out x8, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	out x16, mult num = 1+12 + 2*(1+8) + 4*(1+4) = 51							FIRST_STG_HB_VLP
	out x32, mult num = 1+12 + 2*(1+8) + 4*(1+4) + 8*(1+3) = 83					FIRST_STG_HB_VLP
	
	*in 192k (mult num max - 64)
	out x4, bypass
	out x8, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	out x16, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	out x32, mult num = 1+12 + 2*(1+8) + 4*(1+4) = 51							FIRST_STG_HB_VLP
	
	*in 384k (mult num max - 32)
	out x4, bypass
	out x8, bypass
	out x16, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	out x32, mult num = 1+12 + 2*(1+8) = 31										FIRST_STG_HB_VLP
	
	*in 768k (mult num max - 16)
	out x4, bypass
	out x8, bypass
	out x16, bypass
	out x32, mult num = 1+12 = 13												FIRST_STG_HB_VLP
	--------------------------------------------------------------------------------------------	
***********************************************************************************************/

module rom_coef_control
(
// input config
input [6:0] adr,

output [2:0] st1
);

reg[2:0] rst1;

assign st1 = rst1;

always@( 1 ) begin

	case( adr ) // {mck_mode, lp_mode, ovsmax, fs_in}
	// mck_mode == 0 
	// lp_mode == 0
	// ovs_max == 0 (1024Fs, 192k, high ripple)
	0: rst1 = `FIRST_STG_BYPASS;
	1: rst1 = `FIRST_STG_HR;
	2: rst1 = `FIRST_STG_HR;
	3: rst1 = `FIRST_STG_BYPASS;
	4: rst1 = `FIRST_STG_BYPASS;
	5: rst1 = `FIRST_STG_BYPASS;
	6: rst1 = `FIRST_STG_BYPASS;
	7: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 1 (1024Fs, 384k, high ripple)
	8: rst1 = `FIRST_STG_BYPASS;
	9: rst1 = `FIRST_STG_HR;
	10: rst1 = `FIRST_STG_HR;
	11: rst1 = `FIRST_STG_HB;
	12: rst1 = `FIRST_STG_BYPASS;
	13: rst1 = `FIRST_STG_BYPASS;
	14: rst1 = `FIRST_STG_BYPASS;
	15: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 2 (1024Fs, 768k, high ripple)
	16: rst1 = `FIRST_STG_BYPASS;
	17: rst1 = `FIRST_STG_HR;
	18: rst1 = `FIRST_STG_HR;
	19: rst1 = `FIRST_STG_HB;
	20: rst1 = `FIRST_STG_HB_LP;
	21: rst1 = `FIRST_STG_BYPASS;
	22: rst1 = `FIRST_STG_BYPASS;
	23: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 3 (1024Fs, 1536k, high ripple)
	24: rst1 = `FIRST_STG_BYPASS;
	25: rst1 = `FIRST_STG_HR;
	26: rst1 = `FIRST_STG_HB;
	27: rst1 = `FIRST_STG_HB;
	28: rst1 = `FIRST_STG_HB_LP;
	29: rst1 = `FIRST_STG_HB_VLP;
	30: rst1 = `FIRST_STG_BYPASS;
	31: rst1 = `FIRST_STG_BYPASS;


	// lp_mode == 1
	// ovs_max == 0 (1024Fs, 192k, low power)
	32: rst1 = `FIRST_STG_BYPASS;
	33: rst1 = `FIRST_STG_HB;
	34: rst1 = `FIRST_STG_HB_VLP;
	35: rst1 = `FIRST_STG_BYPASS;
	36: rst1 = `FIRST_STG_BYPASS;
	37: rst1 = `FIRST_STG_BYPASS;
	38: rst1 = `FIRST_STG_BYPASS;
	39: rst1 = `FIRST_STG_BYPASS;
	
	// ovs_max == 1 (1024Fs, 384k, low power)
	40: rst1 = `FIRST_STG_BYPASS;
	41: rst1 = `FIRST_STG_HB;
	42: rst1 = `FIRST_STG_HB_VLP;
	43: rst1 = `FIRST_STG_HB_VLP;
	44: rst1 = `FIRST_STG_BYPASS;
	45: rst1 = `FIRST_STG_BYPASS;
	46: rst1 = `FIRST_STG_BYPASS;
	47: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 2 (1024Fs, 768k, low power)
	48: rst1 = `FIRST_STG_BYPASS;
	49: rst1 = `FIRST_STG_HB;
	50: rst1 = `FIRST_STG_HB_VLP;
	51: rst1 = `FIRST_STG_HB_VLP;
	52: rst1 = `FIRST_STG_HB_VLP;
	53: rst1 = `FIRST_STG_BYPASS;
	54: rst1 = `FIRST_STG_BYPASS;
	55: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 3 (1024Fs, 1536k, low power)
	56: rst1 = `FIRST_STG_BYPASS;
	57: rst1 = `FIRST_STG_HB;
	58: rst1 = `FIRST_STG_HB_VLP;
	59: rst1 = `FIRST_STG_HB_VLP;
	60: rst1 = `FIRST_STG_HB_VLP;
	61: rst1 = `FIRST_STG_HB_VLP;
	62: rst1 = `FIRST_STG_BYPASS;
	63: rst1 = `FIRST_STG_BYPASS;


	// mck_mode == 1
	// lp_mode == 0
	// ovs_max == 0 (768Fs, 192k, high ripple)
	64: rst1 = `FIRST_STG_BYPASS;
	65: rst1 = `FIRST_STG_HR;
	66: rst1 = `FIRST_STG_HR;
	67: rst1 = `FIRST_STG_BYPASS;
	68: rst1 = `FIRST_STG_BYPASS;
	69: rst1 = `FIRST_STG_BYPASS;
	70: rst1 = `FIRST_STG_BYPASS;
	71: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 1 (768Fs, 384k, high ripple)
	72: rst1 = `FIRST_STG_BYPASS;
	73: rst1 = `FIRST_STG_HR;
	74: rst1 = `FIRST_STG_HB;
	75: rst1 = `FIRST_STG_HB;
	76: rst1 = `FIRST_STG_BYPASS;
	77: rst1 = `FIRST_STG_BYPASS;
	78: rst1 = `FIRST_STG_BYPASS;
	79: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 2 (768Fs, 768k, high ripple)
	80: rst1 = `FIRST_STG_BYPASS;
	81: rst1 = `FIRST_STG_HR;
	82: rst1 = `FIRST_STG_HB;
	83: rst1 = `FIRST_STG_HB;
	84: rst1 = `FIRST_STG_HB_LP;
	85: rst1 = `FIRST_STG_BYPASS;
	86: rst1 = `FIRST_STG_BYPASS;
	87: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 3 (768Fs, 1536k, high ripple)
	88: rst1 = `FIRST_STG_BYPASS;
	89: rst1 = `FIRST_STG_HR;
	90: rst1 = `FIRST_STG_HB;
	91: rst1 = `FIRST_STG_HB_LP;
	92: rst1 = `FIRST_STG_HB_VLP;
	93: rst1 = `FIRST_STG_HB_VLP;
	94: rst1 = `FIRST_STG_BYPASS;
	95: rst1 = `FIRST_STG_BYPASS;


	// lp_mode == 1
	// ovs_max == 0 (768Fs, 192k, low power)
	96: rst1 = `FIRST_STG_BYPASS;
	97: rst1 = `FIRST_STG_HB;
	98: rst1 = `FIRST_STG_HB_VLP;
	99: rst1 = `FIRST_STG_BYPASS;
	100: rst1 = `FIRST_STG_BYPASS;
	101: rst1 = `FIRST_STG_BYPASS;
	102: rst1 = `FIRST_STG_BYPASS;
	103: rst1 = `FIRST_STG_BYPASS;
	
	// ovs_max == 1 (768Fs, 384k, low power)
	104: rst1 = `FIRST_STG_BYPASS;
	105: rst1 = `FIRST_STG_HB;
	106: rst1 = `FIRST_STG_HB_VLP;
	107: rst1 = `FIRST_STG_HB_VLP;
	108: rst1 = `FIRST_STG_BYPASS;
	109: rst1 = `FIRST_STG_BYPASS;
	110: rst1 = `FIRST_STG_BYPASS;
	111: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 2 (768Fs, 768k, low power)
	112: rst1 = `FIRST_STG_BYPASS;
	113: rst1 = `FIRST_STG_HB;
	114: rst1 = `FIRST_STG_HB_VLP;
	115: rst1 = `FIRST_STG_HB_VLP;
	116: rst1 = `FIRST_STG_HB_VLP;
	117: rst1 = `FIRST_STG_BYPASS;
	118: rst1 = `FIRST_STG_BYPASS;
	119: rst1 = `FIRST_STG_BYPASS;

	// ovs_max == 3 (768Fs, 1536k, low power)
	120: rst1 = `FIRST_STG_BYPASS;
	121: rst1 = `FIRST_STG_HB;
	122: rst1 = `FIRST_STG_HB_VLP;
	123: rst1 = `FIRST_STG_HB_VLP;
	124: rst1 = `FIRST_STG_HB_VLP;
	125: rst1 = `FIRST_STG_HB_VLP;
	126: rst1 = `FIRST_STG_BYPASS;
	127: rst1 = `FIRST_STG_BYPASS;
	
	default: rst1 = `FIRST_STG_BYPASS;
	endcase
end










endmodule










