`include "defines.v"

`define POLYNOM_ATT			(20'hcb111)
`define ATT_COEF_0db		(12'h800)
`define ATT_COEF_1db		(12'h721)
`define ATT_COEF_2db		(12'h65b)
`define ATT_COEF_3db		(12'h5aa)

module att_4x12
#( parameter W = 32, WR = 8 )
(
// input global sync signals
input clk, clrn, start,
// control inputs
input[1:0] att,
// data input
input signed[31:0] d,

// parallel data output
output signed[W-1:0] q,
output ready
);

// LFSR register
reg[19:0] lfsr;
wire ilfsr = (!att) ? 0 : ( (lfsr) ? lfsr[0] : 1 );

// data & control registers
reg signed[36:0] rsum;
reg[3:0] cnt;
reg rb, rrdy;

// data signals
wire signed[36:0] wd = {d[31], d[31:0], 4'h0};
wire signed[7:0] random = lfsr << (8 - WR);
wire signed[36:0] wrand = random + ( (d < 0) ? 'sh3f : 'sh40 );//random;
wire signed[36:0] wround = wrand << (43 - W);
wire wden = rb & ~start;
wire wsumen = ~start;
wire signed[36:0] wisum = (wsumen) ? (rsum >>> 1) : wround;

// output assigments
assign q = rsum >>> (37 - W);
assign ready = rrdy;

always@( posedge clk or negedge clrn ) begin
	if( !clrn ) begin
		cnt <= 0;
		rsum <= 0; 
		rb <= 0; rrdy <= 0;
		lfsr <= 0;
	end
	else begin
		cnt <= (start) ? 13 : ( (cnt) ? (cnt - 1) : cnt );
		rrdy <= (cnt == 5) ? 1 : 0;
		
		case( att ) // coef bit generate
		0: rb <= ((`ATT_COEF_0db << (cnt-2)) & 12'h800) ? 1 : 0;
		1: rb <= ((`ATT_COEF_1db << (cnt-2)) & 12'h800) ? 1 : 0;
		2: rb <= ((`ATT_COEF_2db << (cnt-2)) & 12'h800) ? 1 : 0;
		3: rb <= ((`ATT_COEF_3db << (cnt-2)) & 12'h800) ? 1 : 0;
		endcase
		
		// random generate
		if( start ) lfsr <= (lfsr >> 1) ^ (`POLYNOM_ATT * ilfsr);
		
		// multiply processing
			`ifdef LOGIC_STYLE_ALTERA
		if( cnt || start ) rsum <= (wden) ? (wisum + wd) : wisum;
			`endif
			`ifdef LOGIC_STYLE_LATTICE
		if( cnt || start ) rsum <= wisum + wd * wden;
			`endif
	end
end




endmodule 









