module init_adr
(
// input global sync signals
input clk, clrn,
input[1:0] sync,

// initialisation signals
input start, next,

// number of used stages
input[2:0] st_last,

// input muxed data
input[6:0] curr_st1, curr_st2, curr_st3, curr_st4, curr_st5,
input[6:0] len1_st1, len1_st2, len1_st3, len1_st4, len1_st5,
input[6:0] len2_st1, len2_st2, len2_st3, len2_st4, len2_st5,

// output initialisation data
output[6:0] curr, repeatnum, lenth1, lenth2,
output[2:0] stage
);

// sync reclock, start delay
reg dstart;

// operational registers
reg[3:0] stcnt, rstg;
reg[6:0] rcurr, rrep, rlen1, rlen2;

// logic variable
reg[6:0] repinit;

// Output assigments
assign curr = rcurr;
assign repeatnum = rrep;
assign lenth1 = rlen1;
assign lenth2 = rlen2;
assign stage = rstg;

always@( 1 ) begin
	case( st_last )
	1: repinit = 1;
	2: repinit = 3;
	3: repinit = 7;
	4: repinit = 15;
	5: repinit = 31;
	default: repinit = 1;
	endcase
end

/*
	Generation initialisation data for adress generation
*/
always@( posedge clk or negedge clrn ) begin
	if( !clrn ) begin
		rcurr <= 0; rrep <= 0; rlen1 <= 0; rlen2 <= 0;
		stcnt <= 0; rstg <= 0; dstart <= 0;
	end
	else begin // clrn scope begin
		dstart <= start;

		stcnt <= (start) ? st_last : ( ((dstart || next) && stcnt) ? (stcnt - 1) : stcnt );	
		rstg <= (dstart || next) ? stcnt : rstg;
		rrep <= (dstart) ? repinit : ( (next) ? (rrep >> 1) : rrep );
			
		if( dstart || next ) begin
			case( stcnt )
			1: begin rcurr <= curr_st1; rlen1 <= len1_st1; rlen2 <= len2_st1; end
			2: begin rcurr <= curr_st2; rlen1 <= len1_st2; rlen2 <= len2_st2; end
			3: begin rcurr <= curr_st3; rlen1 <= len1_st3; rlen2 <= len2_st3; end
			4: begin rcurr <= curr_st4; rlen1 <= len1_st4; rlen2 <= len2_st4; end
			5: begin rcurr <= curr_st5; rlen1 <= len1_st5; rlen2 <= len2_st5; end
			default: begin rcurr <= 7'hxx; rlen1 <= 0; rlen2 <= 0; end
			endcase
		end // sync scope end
		
	end // clrn scope end

end



endmodule














