
`include "config.v"

// Stages coefficients lenth ---------- Taps --- Amount of multiplications = ((Ntaps + 1) / 2)
`define		STAGE_1_LEN_1_HR 			127		// mult - 64
`define		STAGE_1_LEN_2_HR 			125		// mult - 63

`define		STAGE_1_LEN_1_HB 			1		// mult - 1
`define		STAGE_1_LEN_2_HB 			87		// mult - 44

`define		STAGE_1_LEN_1_HB_LP 		1		// mult - 1
`define		STAGE_1_LEN_2_HB_LP 		39		// mult - 20

`define		STAGE_1_LEN_1_HB_VLP 		1		// mult - 1
`define		STAGE_1_LEN_2_HB_VLP 		23		// mult - 12

`define		STAGE_2_LEN_1_HB 			1		// mult - 1
`define		STAGE_2_LEN_2_HB 			15		// mult - 8

`define		STAGE_3_LEN_1_HB 			1		// mult - 1
`define		STAGE_3_LEN_2_HB 			7		// mult - 4

`define		STAGE_4_LEN_1_HB 			1		// mult - 1
`define		STAGE_4_LEN_2_HB 			5		// mult - 3

`define		STAGE_5_LEN_1_HB 			1		// mult - 1
`define		STAGE_5_LEN_2_HB 			3		// mult - 2

`define		STAGE_5_LEN_1_HB_HR 		1		// mult - 1
`define		STAGE_5_LEN_2_HB_HR 		5		// mult - 3

`define		STAGE_BYPASS_LEN_1 			1		// mult - 1
`define		STAGE_BYPASS_LEN_2 			1		// mult - x


// Stages coefficients adresses -------------------------------------------------------------
`define		STAGE_1_COEF_ADR_HR			0	//	att_0: 0x000
`define		STAGE_2_COEF_ADR_HB			381 //	att_0: 0x17d
`define		STAGE_3_COEF_ADR_HB			408 //	att_0: 0x198
`define		STAGE_4_COEF_ADR_HB			423 //	att_0: 0x1a7
`define		STAGE_5_COEF_ADR_HB			435 //	att_0: 0x1b3
`define		STAGE_5_COEF_ADR_HB_HR		444 //	att_0: 0x1bc

`define		STAGE_1_COEF_ADR_HB			512 //	att_0: 0x200
`define		STAGE_1_COEF_ADR_HB_LP		768 //	att_0: 0x300
`define		STAGE_1_COEF_ADR_HB_VLP		832 //	att_0: 0x340
`define		STAGE_BYPASS_ADR			896 //	att_0: 0x380

// First stage enumerate --------------------------------------------------------------------
`define		FIRST_STG_BYPASS	0
`define		FIRST_STG_HR		1
`define		FIRST_STG_HB		2
`define		FIRST_STG_HB_LP		3
`define		FIRST_STG_HB_VLP	4

// Bck number enumerate ---------------------------------------------------------------------
`define		BCK_NUM_16			0
`define		BCK_NUM_18			1
`define		BCK_NUM_20			2
`define		BCK_NUM_22			3
`define		BCK_NUM_24			4
`define		BCK_NUM_32			5
`define		BCK_NUM_CON			6

// Max oversampling enumerate ---------------------------------------------------------------
`define		OVS_MAX_x4			0
`define		OVS_MAX_x8			1
`define		OVS_MAX_x16			2
`define		OVS_MAX_x32			3

// Input frame type enumerate ---------------------------------------------------------------
`define		FRAME_BCK64			0
`define		FRAME_BCK48			1
`define		FRAME_BCK32			2
`define		FRAME_DEFAULT		3

// Input formats enumerate ------------------------------------------------------------------
`define		FORMAT_I2S			0
`define		FORMAT_LJ			1
`define		FORMAT_RJ24			2
`define		FORMAT_RJ16			3

// SPI data field lenth enumerate -----------------------------------------------------------
`define		SPI_DATA_DEFAULT	0
`define		SPI_DATA_16bit		1
`define		SPI_DATA_20bit		2
`define		SPI_DATA_24bit		3

// SPI header lenth enumerate ---------------------------------------------------------------
`define		SPI_HEADER_NONE		0
`define		SPI_HEADER_2bit		1
`define		SPI_HEADER_4bit		2
`define		SPI_HEADER_8bit		3

// SPI headers enumerate --------------------------------------------------------------------
`define HEAD1_DAC8812	(8'h01)
`define HEAD2_DAC8812	(8'h02)
`define HEAD1_AD5791	(8'h01)
`define HEAD2_AD5791	(8'h01)
`define HEAD1_AD5063	(8'h00)
`define HEAD2_AD5063	(8'h00)
`define HEAD1_DAC11001	(8'h01)
`define HEAD2_DAC11001	(8'h01)
`define HEAD1_LTC1592	(8'h20)
`define HEAD2_LTC1592	(8'h20)
`define HEAD1_LTC2752	(8'h30)
`define HEAD2_LTC2752	(8'h32)
`define HEAD1_NONE		(8'h00)
`define HEAD2_NONE		(8'h00)

// Output data width enumerate --------------------------------------------------------------
`define		DATA_16bit			0
`define		DATA_18bit			1
`define		DATA_20bit			2
`define		DATA_22bit			3
`define		DATA_24bit			4

// Output spi data mode enumerate -----------------------------------------------------------
`define		SPI_DIFF_MODE		0
`define		SPI_DIFF_S_MODE		1
`define		SPI_PPLN_MODE		2
`define		SPI_PPLN_S_MODE		3
`define		SPI_CH_S_MODE		4
`define		SPI_RJ24_MODE		5

// Output spi head mode enumerate -----------------------------------------------------------
`define		SPI_HEAD_FREE		0
`define		SPI_HEAD_DAC8812	1
`define		SPI_HEAD_AD5791		2
`define		SPI_HEAD_AD5063		3
`define		SPI_HEAD_DAC11001	4
`define		SPI_HEAD_LTC1592	5
`define		SPI_HEAD_LTC2752	6
`define		SPI_HEAD_RESERVE	7






