module data_out
(
// input global signals
input clk, clrn,
// input control signals
input ready, load,
// input data
input[26:0] d_left, d_right,

// output control
output[8:0] q_adr,
// output data
output[26:0] q_left, q_right
);

reg[26:0] buf_left, buf_right;
reg[5:0] adrcnt;
reg rload;

assign q_left = buf_left;
assign q_right = buf_right;
assign q_adr = {3'h6, adrcnt};

always@( posedge clk or negedge clrn ) begin
	if( !clrn ) begin
		buf_left <= 0; buf_right <= 0;
		adrcnt <= 32;
		rload <= 0;
	end
	else begin		
		rload <= (load) ? 1 : ((ready) ? 0 : rload);		
		if( rload & ready ) begin
			buf_left <= d_left;
			buf_right <= d_right;
			adrcnt <= adrcnt + 1;
		end
	end

end


endmodule






















