module data_write
(
// input global sync signals
input clk, clrn,
input[1:0] sync,

// external signals
input in_ready,
input[2:0] st_mac,

// output stages adress
output[6:0] currpos_st1, currpos_st2, currpos_st3, currpos_st4, currpos_st5, currpos_st6,
// write signal to RAM logic
output[8:0] write_adr,
output write, mux_in, start_mac
);

// Stage current position registers
reg[6:0] pos_st1;
reg[5:0] pos_st2, pos_st3, pos_st4, pos_st5, pos_st6;

// Stage num buf registers
reg[2:0] st_com;
reg in_rdy;

// Output register
reg[8:0] wadr;
reg rwr, start, rmux;

// Async signals
wire[6:0] sum1 = pos_st1 + 1;
wire[5:0] sum2 = pos_st2 + 1;
wire[5:0] sum3 = pos_st3 + 1;
wire[5:0] sum4 = pos_st4 + 1;
wire[5:0] sum5 = pos_st5 + 1;
wire[5:0] sum6 = pos_st6 + 1;

// Output assigments
assign currpos_st1 = pos_st1;
assign currpos_st2 = {1'b0, pos_st2};
assign currpos_st3 = {1'b0, pos_st3};
assign currpos_st4 = {1'b0, pos_st4};
assign currpos_st5 = {1'b0, pos_st5};
assign currpos_st6 = {1'b0, pos_st6};
assign write_adr = wadr;
assign write = rwr;
assign mux_in = rmux;
assign start_mac = rmux;


/*
	Current position registers control
*/
always@(posedge clk or negedge clrn) begin
	if( !clrn ) begin
		// negative global reset - set all registers to zero
		pos_st1 <= 0; pos_st2 <= 0; pos_st3 <= 0;
		pos_st4 <= 0; pos_st5 <= 0; pos_st6 <= 0;
		in_rdy <= 0; st_com <= 0; rwr <= 0; start <= 0; rmux <= 0;
	end
	else begin // clrn scope begin	
	
		in_rdy <= (in_ready) ? 1 : ( (sync == 0) ? 0 : in_rdy );
	
		case( sync )
		0: st_com <= (in_rdy) ? 1 : 0;
		2: st_com <= st_mac;
		default: st_com <= 0;
		endcase
			
		rwr <= (st_com) ? 1 : 0;
		rmux <= (st_com == 1) ? 1 : 0;
		
		if( st_com == 1 ) pos_st1 <= sum1;
		if( st_com == 2 ) pos_st2 <= sum2;
		if( st_com == 3 ) pos_st3 <= sum3;
		if( st_com == 4 ) pos_st4 <= sum4;
		if( st_com == 5 ) pos_st5 <= sum5;
		if( st_com == 6 ) pos_st6 <= sum6;
		
		case( st_com )
		1: wadr <= {2'h0, sum1};
		2: wadr <= {3'h2, sum2};
		3: wadr <= {3'h3, sum3};
		4: wadr <= {3'h4, sum4};
		5: wadr <= {3'h5, sum5};
		6: wadr <= {3'h6, sum6};
		default: wadr <= 9'hxxx;
		endcase	
		
	end // clrn scope end
end




endmodule











