`include "ram_WxD.v"

module data_ram
#( parameter W = 32 )
(
// clock ipnuts
input clk, clrn, 
input iread, istart,

// control adress RAM
input inmux, write,
// input adress RAM
input[8:0] radr, oadr,
input[8:0] wadr,

// input data
input signed[W-1:0] dleft, dright,
// mac data
input signed[W-1:0] mleft, mright,
// output RAM
output signed[W-1:0] qleft, qright,
output qread, qstart
);

reg[1:0] rread, rstart;

wire signed[W-1:0] wdleft = (inmux) ? dleft : mleft;
wire signed[W-1:0] wdright = (inmux) ? dright : mright;
wire[8:0] read_adr = (iread) ? radr : oadr;

assign qread = rread[1];
assign qstart = rstart[1];

always@( posedge clk or negedge clrn ) begin
	rread <= (!clrn) ? 0 : {rread[0], iread};
	rstart <= (!clrn) ? 0 : {rstart[0], istart};
end

ram_WxD #( .W( W*2 ) )
ram_left(
	// global clock input
	.clrn( clrn ), .clk( clk ),	
	// control ipnut
	.rdadr( read_adr ),	.wradr( wadr ),
	.wr( write ),
	// data ipnut
	.d( {wdleft, wdright} ),
	
	// data output
	.q( {qleft, qright} )
);


endmodule











