/**
  ******************************************************************************
  * @file    usbd_audio_out_if.c
  * @author  MCD Application Team
  * @version V1.0.0
  * @date    22-July-2011
  * @brief   This file provides the Audio Out (palyback) interface API.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */ 

/* Includes ------------------------------------------------------------------*/
#include "usbd_audio_core.h"
#include "usbd_audio_out_if.h"
//#include "stm32f4_discovery_audio_codec.h"
#include "stm32f4xx_dma.h"
#include "stm32f4xx_gpio.h"
#include "stm32f4xx_spi.h"
#include "stm32f4xx.h"
#include "misc.h"
#include "stm32f4xx_rcc.h"

#define I2SCFGR_CLEAR_MASK        ((uint16_t)0xF040)
#define RESERVED_MASK             ((uint32_t)0x0F7D0F7D)

/** @addtogroup STM32_USB_OTG_DEVICE_LIBRARY
  * @{
  */


/** @defgroup usbd_audio_out_if 
  * @brief usbd out interface module
  * @{
  */ 

/** @defgroup usbd_audio_out_if_Private_TypesDefinitions
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup usbd_audio_out_if_Private_Defines
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup usbd_audio_out_if_Private_Macros
  * @{
  */ 
/**
  * @}
  */ 


/** @defgroup usbd_audio_out_if_Private_FunctionPrototypes
  * @{
  */
static uint8_t  Init         (uint32_t AudioFreq);
static uint8_t  DeInit       (uint32_t options);
static uint8_t  AudioCmd     (uint32_t* pbuf, uint32_t size, uint8_t cmd);
static uint8_t  VolumeCtl    (uint8_t vol);
static uint8_t  MuteCtl      (uint8_t cmd);
static uint8_t  PeriodicTC   (uint8_t cmd);
static uint8_t  GetState     (void);

/**
  * @}
  */ 

/** @defgroup usbd_audio_out_if_Private_Variables
  * @{
  */ 
AUDIO_FOPS_TypeDef  AUDIO_OUT_fops = 
{
  Init,
  DeInit,
  AudioCmd,
  VolumeCtl,
  MuteCtl,
  PeriodicTC,
  GetState
};

static uint8_t AudioState = AUDIO_STATE_INACTIVE;

/**
  * @}
  */ 

/** @defgroup usbd_audio_out_if_Private_Functions
  * @{
  */ 

/**
  * @brief  Init
  *         Initialize and configures all required resources for audio play function.
  * @param  AudioFreq: Statrtup audio frequency. 
  * @param  Volume: Startup volume to be set.
  * @param  options: specific options passed to low layer function.
  * @retval AUDIO_OK if all operations succeed, AUDIO_FAIL else.
  */
static uint8_t  Init (uint32_t AudioFreq)
{
	//	  	uint32_t temp;

	//   A,C,D,H
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOA | RCC_AHB1Periph_GPIOC | RCC_AHB1Periph_GPIOD |
			               RCC_AHB1Periph_GPIOH,ENABLE);

	// 
	GPIO_InitTypeDef GPIO_InitStructure;

	/* CODEC_I2S pins configuration: SCK and SD pins -----------------------------*/
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_10 | GPIO_Pin_12;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_Init(GPIOC, &GPIO_InitStructure);

	GPIO_PinAFConfig(GPIOC, GPIO_PinSource10, GPIO_AF_SPI3);
	GPIO_PinAFConfig(GPIOC, GPIO_PinSource12, GPIO_AF_SPI3);

	//CODEC_I2S pins configuration: WS
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4 ;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_25MHz;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	GPIO_PinAFConfig(GPIOA, GPIO_PinSource4, GPIO_AF_SPI3);

	/* CODEC_I2S pins configuration: I2S_CKIN pin or I2S_MCLK_OUT*/
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_9;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_Init(GPIOC, &GPIO_InitStructure);

	//I2S_CKIN
	GPIO_PinAFConfig(GPIOC,GPIO_PinSource9,GPIO_AF_SPI2);

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_100MHz;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_Init(GPIOC, &GPIO_InitStructure);

	//I2S_MCLK_OUT(45,1584 )
	GPIO_PinAFConfig(GPIOC,GPIO_PinSource7,GPIO_AF_SPI3);




	//LED init RED,GREEN,ORANGE
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12 | GPIO_Pin_14 | GPIO_Pin_13/* | GPIO_Pin_15*/ ;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_2MHz;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_Init(GPIOD, &GPIO_InitStructure);

	GPIO_ResetBits(GPIOD,GPIO_Pin_12);
	GPIO_ResetBits(GPIOD,GPIO_Pin_14);
	GPIO_ResetBits(GPIOD,GPIO_Pin_13);
//	GPIO_ResetBits(GPIOD,GPIO_Pin_15);

	//   
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1 ;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_25MHz;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_NOPULL;
	GPIO_Init(GPIOC, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8 ;
	GPIO_Init(GPIOF, &GPIO_InitStructure);

	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6 ;
	GPIO_Init(GPIOF, &GPIO_InitStructure);

	// I2S

	RCC_I2SCLKConfig(RCC_I2S2CLKSource_PLLI2S);// AUDIO CLOCK
//	RCC_I2SCLKConfig(RCC_I2S2CLKSource_Ext);// AUDIO CLOCK

	RCC_APB1PeriphClockCmd(RCC_APB1Periph_SPI3, ENABLE);

	SPI3->I2SPR = I2S_MCLKOutput_Enable;// | 0x0002;//I2SDIV=2  PLLI2SN=271  PLLI2SR=6 FS=44100  0,0183%
	if ((AudioFreq == 48000) || (AudioFreq == 44100)) SPI3->I2SPR |= 0x0004;//  44,1  48  SPI = 4
	else if ((AudioFreq == 96000) || (AudioFreq == 88200)) SPI3->I2SPR = 0x0002;//  88,2  96  SPI = 2

	SPI3->I2SCFGR &= I2SCFGR_CLEAR_MASK;

	SPI3->I2SCFGR |= (SPI_I2SCFGR_I2SMOD | I2S_Mode_MasterTx | I2S_Standard_LSB |
			          I2S_DataFormat_32b | I2S_CPOL_Low);

	/* Enable the I2S DMA request */
	SPI_I2S_DMACmd(SPI3, SPI_I2S_DMAReq_Tx, ENABLE);

	/* Enable the DMA clock */
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_DMA1, ENABLE);

	/* Configure the DMA Stream */
	DMA_Cmd(DMA1_Stream7, DISABLE);
	DMA_DeInit(DMA1_Stream7);
	while ((DMA1_Stream7->CR & DMA_SxCR_EN) != 0)
	{
	}

//	temp = DMA1_Stream7->CR;
//	temp &= ~0x0fe37fc0;
//	temp |= (DMA_Channel_0  |DMA_DIR_MemoryToPeripheral | DMA_PeripheralInc_Disable | DMA_MemoryInc_Enable |
//			DMA_PeripheralDataSize_HalfWord | DMA_MemoryDataSize_HalfWord | DMA_Mode_Normal | DMA_Priority_High |
//			DMA_MemoryBurst_Single | DMA_PeripheralBurst_Single);
//	DMA1_Stream7->CR = temp;
//	temp = DMA1_Stream7->FCR;
//	temp &= ~0x00000007;
//	temp |= (DMA_FIFOMode_Disable|DMA_FIFOThreshold_1QuarterFull);
//	DMA1_Stream7->FCR = temp;
//	DMA1_Stream7->NDTR = (uint32_t)0xFFFE;
//	DMA1_Stream7->PAR = 0x40003C0C;  //   SPI3-I2S3
//	DMA1_Stream7->M0AR = (uint32_t)0;

	DMA_InitTypeDef DMA_InitStructure;

	/* Set the parameters to be configured */
	DMA_InitStructure.DMA_Channel = DMA_Channel_0;
	DMA_InitStructure.DMA_PeripheralBaseAddr = 0x40003C0C;  //   SPI3-I2S3
	DMA_InitStructure.DMA_Memory0BaseAddr = (uint32_t)0;      /* This field will be configured in play function */
	DMA_InitStructure.DMA_DIR = DMA_DIR_MemoryToPeripheral;
	DMA_InitStructure.DMA_BufferSize = (uint32_t)0xFFFE;      /* This field will be configured in play function */
	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
	DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
	DMA_InitStructure.DMA_Mode = DMA_Mode_Normal;
	DMA_InitStructure.DMA_Priority = DMA_Priority_High;
	DMA_InitStructure.DMA_FIFOMode = DMA_FIFOMode_Disable;
	DMA_InitStructure.DMA_FIFOThreshold = DMA_FIFOThreshold_1QuarterFull;
	DMA_InitStructure.DMA_MemoryBurst = DMA_MemoryBurst_Single;
	DMA_InitStructure.DMA_PeripheralBurst = DMA_PeripheralBurst_Single;
	DMA_Init(DMA1_Stream7, &DMA_InitStructure);

	/* Enable the selected DMA interrupts  */
	DMA_ITConfig(DMA1_Stream7, DMA_IT_TC, ENABLE);

	/* I2S DMA IRQ Channel configuration */
	NVIC_InitTypeDef NVIC_InitStructure;
	NVIC_InitStructure.NVIC_IRQChannel = DMA1_Stream7_IRQn;
	NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
	NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
	NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	NVIC_Init(&NVIC_InitStructure);

	return AUDIO_OK;
}

/**
  * @brief  DeInit
  *         Free all resources used by low layer and stops audio-play function.
  * @param  options: options passed to low layer function.
  * @retval AUDIO_OK if all operations succeed, AUDIO_FAIL else.
  */
static uint8_t  DeInit       (uint32_t options)
{
  /* Update the Audio state machine */
//  AudioState = AUDIO_STATE_INACTIVE;
  
  return AUDIO_OK;
}

/**
  * @brief  AudioCmd
  *         Play, Stop, Pause or Resume current file.
  * @param  pbuf: address from which file shoud be played.
  * @param  size: size of the current buffer/file. in BYTES
  * @param  cmd: command to be executed, can be AUDIO_CMD_PLAY , AUDIO_CMD_PAUSE, 
  *              AUDIO_CMD_RESUME or AUDIO_CMD_STOP.
  * @retval AUDIO_OK if all operations succeed, AUDIO_FAIL else.
  */
static uint8_t  AudioCmd(uint32_t* pbuf,
                         uint32_t size,
                         uint8_t cmd)
{
	  /* Check the current state */
	//  if ((AudioState == AUDIO_STATE_INACTIVE) || (AudioState == AUDIO_STATE_ERROR))
	//  {
	//    AudioState = AUDIO_STATE_ERROR;
	//    return AUDIO_FAIL;
	//  }

	  switch (cmd)
	  {
	    /* Process the PLAY command ----------------------------*/
	  case AUDIO_CMD_PLAY:
	  {
		  //DMA_Cmd(DMA1_Stream7, DISABLE);
		  DMA1_Stream7->CR &= ~(uint32_t)DMA_SxCR_EN;
		  while ((DMA1_Stream7->CR & DMA_SxCR_EN) != 0)
		  {
		  }
		  DMA1_Stream7->NDTR = (uint32_t)size;
		  DMA1_Stream7->M0AR = (uint32_t)pbuf;

	      //DMA_Cmd(DMA1_Stream7, ENABLE);
		  DMA1_Stream7->CR |= (uint32_t)DMA_SxCR_EN;

		  /* If the I2S peripheral is still not enabled, enable it */
		  if ((SPI3->I2SCFGR & 0x0400) == 0)
		  {
			  //I2S_Cmd(SPI3, ENABLE);
			  SPI3->I2SCFGR |= SPI_I2SCFGR_I2SE;
		  }

		  if ((SPI3->CR2 & SPI_I2S_DMAReq_Tx)==0)
		  {
			  //SPI_I2S_DMACmd(SPI3, SPI_I2S_DMAReq_Tx, ENABLE);
			  SPI3->CR2 |= (uint16_t)SPI_I2S_DMAReq_Tx;
		  }
	      return AUDIO_OK;
	  }

	    /* Process the STOP command ----------------------------*/
	  case AUDIO_CMD_STOP:
	  {
		  /* Stop the Transfer on the I2S side: Stop and disable the DMA stream */
		  //DMA_Cmd(DMA1_Stream7, DISABLE);
		  DMA1_Stream7->CR &= ~(uint32_t)DMA_SxCR_EN;

		  /* Clear all the DMA flags for the next transfer */
		  //DMA_ClearFlag(DMA1_Stream7, DMA_FLAG_TCIF7 |DMA_FLAG_HTIF7 | DMA_FLAG_FEIF7 | DMA_FLAG_TEIF7);
		  DMA1->HIFCR = (uint32_t)((DMA_FLAG_TCIF7 | DMA_FLAG_HTIF7 | DMA_FLAG_FEIF7 |
				                    DMA_FLAG_TEIF7) & RESERVED_MASK);

		  //SPI_I2S_DMACmd(SPI3, SPI_I2S_DMAReq_Tx, DISABLE);
		  SPI3->CR2 &= ~(uint16_t)SPI_I2S_DMAReq_Tx;
	      return AUDIO_OK;
	  }

	    /* Process the PAUSE command ---------------------------*/
	  case AUDIO_CMD_PAUSE:
	  {
		  /* Stop the Transfer on the I2S side: Stop and disable the DMA stream */
		  //DMA_Cmd(DMA1_Stream7, DISABLE);
		  DMA1_Stream7->CR &= ~(uint32_t)DMA_SxCR_EN;

		  //SPI_I2S_DMACmd(SPI3, SPI_I2S_DMAReq_Tx, DISABLE);
		  SPI3->CR2 &= ~(uint16_t)SPI_I2S_DMAReq_Tx;
	      return AUDIO_OK;
	  }

	    /* Unsupported command ---------------------------------*/
	  default:
	    return AUDIO_FAIL;
	  }
}

/**
  * @brief  VolumeCtl
  *         Set the volume level in %
  * @param  vol: volume level to be set in % (from 0% to 100%)
  * @retval AUDIO_OK if all operations succeed, AUDIO_FAIL else.
  */
static uint8_t  VolumeCtl    (uint8_t vol)
{
  /* Call low layer volume setting function */  
  
  /*
  if (EVAL_AUDIO_VolumeCtl(vol) != 0)
  {
    AudioState = AUDIO_STATE_ERROR;
    return AUDIO_FAIL;
  }
  */
  return AUDIO_OK;
}

/**
  * @brief  MuteCtl
  *         Mute or Unmute the audio current output
  * @param  cmd: can be 0 to unmute, or 1 to mute.
  * @retval AUDIO_OK if all operations succeed, AUDIO_FAIL else.
  */
static uint8_t  MuteCtl      (uint8_t cmd)
{
  /* Call low layer mute setting function */  
  
/*  if (EVAL_AUDIO_Mute(cmd) != 0)
  {
    AudioState = AUDIO_STATE_ERROR;
    return AUDIO_FAIL;
  }*/
  
  
  return AUDIO_OK;
}

/**
  * @brief  
  *         
  * @param  
  * @param  
  * @retval AUDIO_OK if all operations succeed, AUDIO_FAIL else.
  */
static uint8_t  PeriodicTC   (uint8_t cmd)
{

  
  return AUDIO_OK;
}


/**
  * @brief  GetState
  *         Return the current state of the audio machine
  * @param  None
  * @retval Current State.
  */
static uint8_t  GetState   (void)
{
  return AudioState;
}

/**
  * @}
  */ 

/**
  * @}
  */ 

/**
  * @}
  */ 

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/
